/*
 * Decompiled with CFR 0.152.
 */
package reder.layout;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import reder.network.EdgeBank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGraphAlgorithms {
    private mxGraph g = new mxGraph();
    private Object parent = this.g.getDefaultParent();
    private mxGraphLayout layout;
    private Point2D[] ponto;
    private double p = 1.0;
    private double q = 1.0;
    private int r = 1;

    public void inputArray(int sizeArrayNode, ArrayList<EdgeBank> arrayEdge, int tipo, double width, double height, String panelType) {
        int sizeArrayEdge = arrayEdge.size();
        if (sizeArrayEdge > 0 || tipo < 2) {
            int i;
            Object[] vertex = new Object[sizeArrayNode];
            for (i = 0; i < sizeArrayNode; ++i) {
                vertex[i] = this.g.insertVertex(this.parent, "0", null, 0.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < sizeArrayEdge; ++i) {
                this.g.insertEdge(this.parent, null, null, vertex[arrayEdge.get(i).getA()], vertex[arrayEdge.get(i).getB()]);
            }
            this.layout = this.useLayout(this.g, tipo);
            Object[] lista = this.g.getChildVertices(this.g.getDefaultParent());
            this.ponto = new Point2D[sizeArrayNode];
            double xMax = 0.0;
            double yMax = 0.0;
            double xMin = 1.0E8;
            double yMin = 1.0E8;
            for (int i2 = 0; i2 < sizeArrayNode; ++i2) {
                mxGeometry point = this.g.getCellGeometry(lista[i2]);
                double x = point.getX();
                double y = point.getY();
                if (x > xMax) {
                    xMax = x;
                }
                if (y > yMax) {
                    yMax = y;
                }
                if (x < xMin) {
                    xMin = x;
                }
                if (y < yMin) {
                    yMin = y;
                }
                this.ponto[i2] = new Point2D.Double(point.getX(), point.getY());
            }
            double escala = 0.9;
            if (panelType.equals("container")) {
                escala = 0.95;
            }
            if (tipo == 0) {
                this.setPositionNew(xMax, yMax, xMin, yMin, escala, width, height);
            } else {
                this.setPositionOld(xMax, yMax, xMin, yMin, escala, width, height);
            }
        }
    }

    private mxGraphLayout useLayout(mxGraph g, int i) {
        switch (i) {
            case 0: {
                return this.useOrganicLayout(g);
            }
            case 1: {
                return this.useCircleLayout(g);
            }
            case 2: {
                return this.useCompactTreeLayout(g);
            }
            case 3: {
                return this.useHierarchicalLayout(g);
            }
        }
        return this.useOrganicLayout(g);
    }

    public Point2D[] getArrayPontos() {
        return this.ponto;
    }

    private mxGraphLayout useOrganicLayout(mxGraph g) {
        mxOrganicLayout layoutFinal = new mxOrganicLayout(g);
        layoutFinal.setEdgeLengthCostFactor(layoutFinal.getEdgeLengthCostFactor() * 1.0 / this.p);
        layoutFinal.execute(this.parent);
        return layoutFinal;
    }

    private mxGraphLayout useCircleLayout(mxGraph g) {
        mxCircleLayout layoutFinal = new mxCircleLayout(g);
        layoutFinal.execute(this.parent);
        return layoutFinal;
    }

    private mxGraphLayout useCompactTreeLayout(mxGraph g) {
        mxCompactTreeLayout layoutFinal = new mxCompactTreeLayout(g);
        layoutFinal.setNodeDistance(layoutFinal.getNodeDistance() + this.r);
        layoutFinal.setLevelDistance(layoutFinal.getLevelDistance() + this.r);
        layoutFinal.execute(this.parent);
        return layoutFinal;
    }

    private mxGraphLayout useHierarchicalLayout(mxGraph g) {
        mxHierarchicalLayout layoutFinal = new mxHierarchicalLayout(g);
        layoutFinal.execute(this.parent);
        return layoutFinal;
    }

    private void setPositionNew(double xMax, double yMax, double xMin, double yMin, double escala, double width, double height) {
        double length = Math.min(width, height) * escala;
        double dx = xMax - xMin;
        double dy = yMax - yMin;
        double rescale = length / Math.max(dx, dy);
        double addx = (width - dx * rescale) / 2.0;
        double addy = (height - dy * rescale) / 2.0;
        for (int i = 0; i < this.ponto.length; ++i) {
            double x = (this.ponto[i].getX() - xMin) * rescale + addx;
            double y = (this.ponto[i].getY() - yMin) * rescale + addy;
            this.ponto[i].setLocation(x, y);
        }
    }

    private void setPositionOld(double xMax, double yMax, double xMin, double yMin, double escala, double width, double height) {
        double tw;
        double th;
        double hmax;
        double hmin;
        if (width > height) {
            hmin = height * escala;
            hmax = width * escala;
            th = 0.0;
            tw = 1.0;
        } else {
            hmin = width * escala;
            hmax = height * escala;
            th = 1.0;
            tw = 0.0;
        }
        xMin = xMin / xMax * hmin + (hmax - hmin) * tw;
        yMin = yMin / yMax * hmin + (hmax - hmin) * th;
        double dx = xMin / 2.0;
        double dy = yMin / 2.0;
        for (int i = 0; i < this.ponto.length; ++i) {
            double x = this.ponto[i].getX() / xMax * hmin + (hmax - hmin) * tw;
            double y = this.ponto[i].getY() / yMax * hmin + (hmax - hmin) * th;
            x = x - dx + (width - width * escala) / 2.0;
            y = y - dy + (height - height * escala) / 2.0;
            this.ponto[i].setLocation(x, y);
        }
    }
}

