/*
 * Decompiled with CFR 0.152.
 */
package reder.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadModels {
    private String openAddress;
    private String taskProgress;
    private String modelType;
    private static int numSgenes;
    private static int numEgenes;
    private static String controlID;
    private static String stimulusID;
    private static String[] sGeneIDs;
    private static int[] control;
    private static int[] stimulus;
    private static int[][] arraySgenes;

    public LoadModels() {
        this.reset();
    }

    private void reset() {
        controlID = null;
        stimulusID = null;
        sGeneIDs = null;
        control = null;
        stimulus = null;
        arraySgenes = null;
        this.openAddress = null;
        this.taskProgress = "running";
        numSgenes = 0;
        numEgenes = 0;
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public int getNumEgenes() {
        return numEgenes;
    }

    public int getNumSgenes() {
        return numSgenes;
    }

    public int[] getControlVector() {
        return control;
    }

    public int[] getStimulusVector() {
        return stimulus;
    }

    public int[][] getArraySgenes() {
        return arraySgenes;
    }

    public String getControlID() {
        return controlID;
    }

    public String getStimulusID() {
        return stimulusID;
    }

    public String[] getSgeneIDs() {
        return sGeneIDs;
    }

    public void inputAndGo(String openAddress, String attrType) {
        this.reset();
        this.openAddress = openAddress;
        this.modelType = attrType;
        try {
            this.loadNestedModel();
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadNestedModel() throws FileNotFoundException, IOException {
        String strLine = "";
        FileReader inCont = new FileReader(this.openAddress);
        BufferedReader brCont = new BufferedReader(inCont);
        strLine = brCont.readLine();
        String[] split = strLine.split("[\\s;]+");
        while (strLine != null) {
            strLine = brCont.readLine();
            ++numEgenes;
        }
        --numEgenes;
        controlID = split[1];
        stimulusID = split[2];
        numSgenes = split.length - 3;
        sGeneIDs = new String[numSgenes];
        for (int i = 0; i < numSgenes; ++i) {
            LoadModels.sGeneIDs[i] = split[i + 3];
        }
        control = new int[numEgenes];
        stimulus = new int[numEgenes];
        arraySgenes = new int[numEgenes][numSgenes];
        inCont.close();
        brCont.close();
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        strLine = br.readLine();
        String toCheck = String.valueOf(numSgenes + 1);
        Pattern inputPattern = Pattern.compile("^([^\\s]+)[\\s;]+([0-9&&[^2-9]]{1}[\\s;]+){" + toCheck + ",}");
        if (numSgenes >= 2) {
            strLine = br.readLine();
            boolean flag = false;
            int i = 0;
            while (strLine != null && !flag) {
                Matcher matcher = inputPattern.matcher(strLine);
                if (matcher.find()) {
                    int num;
                    split = strLine.split("[\\s;]+");
                    LoadModels.control[i] = num = Integer.parseInt(split[1]);
                    LoadModels.stimulus[i] = num = Integer.parseInt(split[2]);
                    for (int j = 0; j < numSgenes; ++j) {
                        LoadModels.arraySgenes[i][j] = num = Integer.parseInt(split[j + 3]);
                    }
                } else {
                    flag = true;
                    this.taskProgress = "notBinaryData";
                }
                strLine = br.readLine();
                ++i;
            }
            if (!flag) {
                this.taskProgress = "endload";
            }
        } else {
            this.taskProgress = "badColNumber";
        }
        in.close();
        br.close();
    }
}

