/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reder.application.Desktop;
import reder.application.GraphTask;

public class RedPreferences {
    private final String Rversion;
    private Preferences prefs;
    private String defaultRhome;
    private String defaultShellStatus;
    private String shareDir;
    private String includeDir;
    private String docDir;
    private String userLibsDir;
    private int defaultServerPort;
    private String defaultLibRHome;
    private String additionalPaths;
    private String libMark;
    private boolean RView;
    private boolean doInBackground;
    private String userdir;

    RedPreferences() {
        String osType = this.getOsType();
        if (osType.equals("win")) {
            this.defaultRhome = "C:/R-2.12.0";
            this.defaultLibRHome = "C:/R-2.12.0/bin/i386";
            this.additionalPaths = "C:/R-2.12.0/library/rJava/jri";
            this.libMark = "/R.dll";
        } else if (osType.equals("mac")) {
            this.defaultRhome = "/Library/Frameworks/R.framework/Resources";
            this.defaultLibRHome = "/Library/Frameworks/R.framework/Resources/lib";
            this.additionalPaths = "/Library/Frameworks/R.framework/Resources/library/rJava/jri";
            this.libMark = "/libR.dylib";
        } else {
            this.defaultRhome = "/usr/lib64/R";
            this.defaultLibRHome = "/usr/lib64/R/lib";
            this.additionalPaths = "/usr/lib64/R/library/rJava/jri";
            this.libMark = "/libR.so";
        }
        this.shareDir = this.defaultRhome + "/share";
        this.includeDir = this.defaultRhome + "/include";
        this.docDir = this.defaultRhome + "/doc";
        this.userLibsDir = this.defaultRhome + "/library";
        this.Rversion = "2.12.0";
        this.doInBackground = true;
        this.defaultServerPort = 9091;
        this.defaultShellStatus = "nonvalidated";
        this.RView = true;
        this.prefs = Preferences.userRoot().node(this.getClass().getName());
        String ini0 = "Rshell";
        String ini1 = "Rhome";
        String ini3 = "libRhome";
        String ini4 = "additionalPaths";
        String ini5 = "serverPort";
        this.prefs.get(ini0, this.defaultShellStatus);
        this.prefs.get(ini1, this.defaultRhome);
        this.prefs.get(ini3, this.defaultLibRHome);
        this.prefs.get(ini4, this.additionalPaths);
        this.prefs.getInt(ini5, this.defaultServerPort);
        String ini6 = "RView";
        String ini7 = "doInBackground";
        this.prefs.getBoolean(ini6, this.RView);
        this.prefs.getBoolean(ini7, this.doInBackground);
        String ini8 = "shareDir";
        String ini9 = "includeDir";
        String ini10 = "docDir";
        String ini11 = "userLibsDir";
        this.prefs.get(ini8, this.shareDir);
        this.prefs.get(ini9, this.includeDir);
        this.prefs.get(ini10, this.docDir);
        this.prefs.get(ini11, this.userLibsDir);
        String ini12 = "userdir";
        this.userdir = System.getProperty("user.dir");
        this.prefs.get(ini12, this.userdir);
    }

    public void resetPreferences() {
        this.prefs.put("Rshell", this.defaultShellStatus);
        this.prefs.put("Rhome", this.defaultRhome);
        this.prefs.put("libRhome", this.defaultLibRHome);
        this.prefs.put("additionalPaths", this.additionalPaths);
        this.prefs.putInt("serverPort", this.defaultServerPort);
        this.prefs.putBoolean("RView", this.RView);
        this.prefs.putBoolean("doInBackground", this.doInBackground);
        this.prefs.put("shareDir", this.shareDir);
        this.prefs.put("includeDir", this.includeDir);
        this.prefs.put("docDir", this.docDir);
        this.prefs.put("userLibsDir", this.userLibsDir);
    }

    public boolean getOptionRView() {
        return this.prefs.getBoolean("RView", this.RView);
    }

    public boolean getOptionRdoInBackground() {
        return this.prefs.getBoolean("doInBackground", this.doInBackground);
    }

    public String getStatusRshell() {
        return this.prefs.get("Rshell", this.defaultShellStatus);
    }

    public String getRHome() {
        return this.prefs.get("Rhome", this.defaultRhome);
    }

    public String getShareDir() {
        return this.prefs.get("shareDir", this.shareDir);
    }

    public String getIncludeDir() {
        return this.prefs.get("includeDir", this.includeDir);
    }

    public String getDocDir() {
        return this.prefs.get("docDir", this.docDir);
    }

    public String getUserLibsDir() {
        return this.prefs.get("userLibsDir", this.userLibsDir);
    }

    public int getServerPort() {
        return this.prefs.getInt("serverPort", this.defaultServerPort);
    }

    public String getLibRHome() {
        String libs = this.prefs.get("libRhome", this.defaultLibRHome);
        return libs;
    }

    public String getAdditionalPaths() {
        String libs = this.prefs.get("additionalPaths", this.additionalPaths);
        return libs;
    }

    public String getLibMarkPath() {
        return this.libMark;
    }

    public String getRversion() {
        return this.Rversion;
    }

    public String getUserDir() {
        return this.prefs.get("userdir", this.userdir);
    }

    public final String getOsType() {
        String osType = System.getProperty("os.name");
        Pattern ptWin = Pattern.compile("win", 2);
        Pattern ptMac = Pattern.compile("mac", 2);
        Pattern ptLin = Pattern.compile("linux", 2);
        if (ptWin.matcher(osType).find()) {
            return "win";
        }
        if (ptMac.matcher(osType).find()) {
            return "mac";
        }
        if (ptLin.matcher(osType).find()) {
            return "linux";
        }
        return "unknown";
    }

    public boolean isRefsValid() {
        if (this.getOsType().equals("win")) {
            String syspath = System.getenv("PATH");
            syspath = syspath != null ? syspath.replace("\\", "/") : "";
            Pattern pt = Pattern.compile(this.getRHome() + "($|;)");
            Matcher matcher = pt.matcher(syspath);
            File ftest1 = new File(this.getLibRHome() + this.libMark);
            File ftest2 = new File(this.getAdditionalPaths() + this.libMark);
            File ftest3 = new File(this.getRHome() + this.libMark);
            if (matcher.find()) {
                return ftest1.exists() || ftest2.exists() || ftest3.exists();
            }
            return false;
        }
        String syspath = System.getenv("R_HOME");
        syspath = syspath != null ? syspath.replace("\\", "/") : "";
        Pattern pt = Pattern.compile(this.getRHome() + "($|;)");
        Matcher matcher = pt.matcher(syspath);
        File ftest1 = new File(this.getLibRHome() + this.libMark);
        File ftest2 = new File(this.getAdditionalPaths() + this.libMark);
        File ftest3 = new File(this.getRHome() + this.libMark);
        if (matcher.find()) {
            return ftest1.exists() || ftest2.exists() || ftest3.exists();
        }
        return false;
    }

    public boolean checkRhome() {
        File rtest = new File(this.getRHome());
        return rtest.isDirectory();
    }

    public boolean checkRhome(String pathtest) {
        File rtest = this.getOsType().equals("win") || this.getOsType().equals("mac") ? new File(pathtest + "/include") : new File(pathtest);
        return rtest.isDirectory();
    }

    public boolean checkLibs() {
        File ftest1 = new File(this.getLibRHome() + this.libMark);
        File ftest2 = new File(this.getAdditionalPaths() + this.libMark);
        File ftest3 = new File(this.getRHome() + this.libMark);
        return ftest1.exists() || ftest2.exists() || ftest3.exists();
    }

    public boolean checkLibs(String pathtest) {
        File ftest = new File(pathtest + this.libMark);
        return ftest.exists();
    }

    public String getValidRversion() {
        return this.Rversion;
    }

    public String getLocalDir() {
        String s = new File("").getAbsolutePath().replace("\\", "/");
        URL url = this.getClass().getResource("/reder/application/resources/front.png");
        String syspath = url.getPath();
        try {
            syspath = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(RedPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        Pattern pt = Pattern.compile("^(file:/)(.+)(!/reder/application/resources/front.png)");
        Matcher matcher = pt.matcher(syspath);
        if (matcher.find()) {
            String m = matcher.group(2);
            if (this.getOsType().equals("win")) {
                File f = new File(m);
                if (f.exists()) {
                    m = f.getParent().replace("\\", "/");
                    return m;
                }
                return s;
            }
            File f = new File("/" + m);
            if (f.exists()) {
                m = f.getParent().replace("\\", "/");
                return m;
            }
            return s;
        }
        return s;
    }

    public void setOptionRView(boolean opt) {
        this.prefs.putBoolean("RView", opt);
    }

    public void setOptionRdoInBackground(boolean opt) {
        this.prefs.putBoolean("doInBackground", opt);
    }

    public void setStatusRshell(String status) {
        this.prefs.put("Rshell", status);
    }

    public void setRHome(String path) {
        this.prefs.put("Rhome", path);
    }

    public void setShareDir(String path) {
        this.prefs.put("shareDir", path);
    }

    public void setIncludeDir(String path) {
        this.prefs.put("includeDir", path);
    }

    public void setDocDir(String path) {
        this.prefs.put("docDir", path);
    }

    public void setUserLibsDir(String path) {
        this.prefs.put("userLibsDir", path);
    }

    public void setLibRPath(String path) {
        this.prefs.put("libRhome", path);
    }

    public void setAdditionalPaths(String path) {
        this.prefs.put("additionalPaths", path);
    }

    public void setServerPort(int port) {
        this.prefs.putInt("serverPort", port);
    }

    public void setServerPort(String port) {
        int p = 9091;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.prefs.putInt("serverPort", p);
    }

    public void setUserdir(int dir) {
        this.prefs.putInt("userdir", dir);
    }

    public void loadRlibs() {
        String osType = this.getOsType();
        String nativeLib = osType.equals("win") ? "jri.dll" : (osType.equals("mac") ? "libjri.jnilib" : (osType.equals("linux") ? "libjri.so" : "jri.dll"));
        File tempFile = null;
        File tempAdress = null;
        try {
            int rc;
            InputStream in = ClassLoader.class.getResource("/reder/application/resources/" + nativeLib).openStream();
            tempFile = File.createTempFile("temp", ".lib");
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] temp = new byte[4096];
            while ((rc = in.read(temp)) > 0) {
                out.write(temp, 0, rc);
            }
            in.close();
            out.close();
            tempFile.deleteOnExit();
            tempAdress = new File(tempFile.getParent() + "/" + nativeLib);
            tempFile.renameTo(tempAdress);
        }
        catch (IOException ex) {
            Logger.getLogger(GraphTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        String setPath = System.getProperty("java.library.path");
        String ps = System.getProperty("path.separator");
        setPath = setPath + ps + this.getLocalDir() + ps + this.getAdditionalPaths() + ps + tempFile.getParent();
        System.setProperty("java.library.path", setPath);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

