/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.TextProvidingRenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LocationAwareTextExtractingPdfContentRenderListener
implements TextProvidingRenderListener {
    static boolean DUMP_STATE = false;
    private Vector chunkStart;
    private Vector chunkEnd;
    private StringBuffer chunkText;
    private List<LocationOnPage> locationalResult;
    boolean firstRender;

    public LocationAwareTextExtractingPdfContentRenderListener() {
        this.reset();
    }

    public void reset() {
        this.beginTextBlock();
        this.locationalResult = new ArrayList<LocationOnPage>();
    }

    public void beginTextBlock() {
        this.firstRender = true;
        this.chunkText = new StringBuffer();
    }

    public void endTextBlock() {
        if (!this.firstRender) {
            this.captureChunk(this.chunkText.toString());
        }
    }

    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        Collections.sort(this.locationalResult);
        StringBuffer sb = new StringBuffer();
        LocationOnPage lastLocation = null;
        Iterator<LocationOnPage> i$ = this.locationalResult.iterator();
        while (i$.hasNext()) {
            LocationOnPage locationOnPage;
            LocationOnPage location = locationOnPage = i$.next();
            if (lastLocation == null) {
                sb.append(location.text);
            } else if (location.sameLine(lastLocation)) {
                sb.append('\t');
                sb.append(location.text);
            } else {
                sb.append('\n');
                sb.append(location.text);
            }
            lastLocation = location;
        }
        return sb.toString();
    }

    private void dumpState() {
        for (LocationOnPage location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    public void renderText(TextRenderInfo renderInfo) {
        float spacing;
        boolean newChunk = false;
        Vector start = renderInfo.getStartPoint();
        Vector end = renderInfo.getEndPoint();
        float singleSpaceWidth = renderInfo.getSingleSpaceWidth();
        if (!this.firstRender) {
            float spacing2;
            Vector cross;
            float sameLineThreshold;
            Vector x0 = start;
            Vector x2 = this.chunkEnd;
            Vector x1 = this.chunkStart;
            float dist = x2.subtract(x1).cross(x1.subtract(x0)).lengthSquared() / x2.subtract(x1).lengthSquared();
            newChunk = dist > (sameLineThreshold = 1.0f) ? true : ((double)(cross = start.subtract(this.chunkEnd).cross(this.chunkEnd.subtract(this.chunkStart))).length() <= 1.0E-4 ? ((spacing2 = this.chunkEnd.subtract(start).length()) < -singleSpaceWidth ? true : spacing2 > singleSpaceWidth * 4.0f) : true);
        }
        if (newChunk) {
            this.captureChunk(this.chunkText.toString());
            this.chunkText.setLength(0);
            this.chunkStart = start;
        } else if (!this.firstRender && this.chunkText.charAt(this.chunkText.length() - 1) != ' ' && renderInfo.getText().charAt(0) != ' ' && (spacing = this.chunkEnd.subtract(start).length()) > singleSpaceWidth / 2.0f) {
            this.chunkText.append(' ');
        }
        this.chunkText.append(renderInfo.getText());
        if (this.firstRender) {
            this.chunkStart = start;
            this.firstRender = false;
        }
        this.chunkEnd = end;
    }

    private void captureChunk(String text) {
        LocationOnPage location = new LocationOnPage(text, this.chunkStart, this.chunkEnd);
        this.locationalResult.add(location);
    }

    public void renderImage(ImageRenderInfo renderInfo) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationOnPage
    implements Comparable<LocationOnPage> {
        final String text;
        final Vector startLocation;
        final Vector endLocation;
        final Vector orientationVector;
        final int orientationMagnitude;
        final int distPerpendicular;
        final int distParallel;

        public LocationOnPage(String string, Vector startLocation, Vector endLocation) {
            this.text = string;
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.orientationVector = endLocation.subtract(startLocation).normalize();
            this.orientationMagnitude = (int)(this.orientationVector.get(1) * 1000.0f);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallel = (int)this.orientationVector.dot(startLocation);
        }

        private void printDiagnostics() {
            System.out.println("Text (@" + this.startLocation + " -> " + this.endLocation + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.orientationMagnitude);
            System.out.println("distPerpendicular: " + this.distPerpendicular);
            System.out.println("distParallel: " + this.distParallel);
        }

        public boolean sameLine(LocationOnPage as) {
            if (this.orientationMagnitude != as.orientationMagnitude) {
                return false;
            }
            return this.distPerpendicular == as.distPerpendicular;
        }

        @Override
        public int compareTo(LocationOnPage rhs) {
            int rslt = LocationOnPage.compareInts(this.orientationMagnitude, rhs.orientationMagnitude);
            if (rslt != 0) {
                return rslt;
            }
            rslt = LocationOnPage.compareInts(this.distPerpendicular, rhs.distPerpendicular);
            if (rslt != 0) {
                return rslt;
            }
            rslt = LocationOnPage.compareInts(this.distParallel, rhs.distParallel);
            return rslt;
        }

        private static int compareInts(int int1, int int2) {
            return int1 == int2 ? 0 : (int1 < int2 ? -1 : 1);
        }
    }
}

