/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.TreeMap;
import net.sf.picard.metrics.MetricBase;

public class MetricsDoclet {
    public static boolean start(RootDoc root) {
        TreeMap<String, ClassDoc> metricsClasses = new TreeMap<String, ClassDoc>();
        for (ClassDoc doc : root.classes()) {
            if (!MetricsDoclet.isMetricsClass(doc)) continue;
            System.out.println("Processing " + doc.qualifiedTypeName());
            metricsClasses.put(doc.typeName(), doc);
        }
        PrintStream out = MetricsDoclet.getOutput(root);
        if (out == null) {
            return false;
        }
        out.println("<head>");
        out.println("  <title>Picard Metrics Definitions</title>");
        out.println("  <style>");
        out.println("    body { font-family: Arial; background-color: white; font-size: 10pt; }");
        out.println("    h2 { color: red; }");
        out.println("    .class_description { font-style: italic; }");
        out.println("    .metric_column_def { padding-bottom: 0px; margin-bottom: 8px; }");
        out.println("    .metric_column_def span { font-weight: bold; color: #222222; font-style: italic; }");
        out.println("  </style>");
        out.println("</head>");
        out.println("<h1>Picard Metrics Definitions</h1>");
        out.println("<h2>Table Of Contents</h2>");
        out.println("<ol>");
        for (ClassDoc doc : metricsClasses.values()) {
            out.println("<li><a href=\"#" + doc.name() + "\">" + doc.name() + "</a>: " + MetricsDoclet.firstSentence((Doc)doc) + "</li>");
        }
        out.println("</ol>");
        for (ClassDoc doc : metricsClasses.values()) {
            out.println("<a name=\"" + doc.name() + "\"");
            out.println("<h2>" + doc.name() + "</h2>");
            out.println("<p class=\"class_description\">" + doc.commentText() + "</p>");
            out.println("<h3>Column Definitions</h3>");
            for (FieldDoc field : doc.fields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                out.append("<div class=\"metric_column_def\"><span>" + field.name() + ": </span>");
                out.append(field.commentText());
                out.println("</div>");
            }
        }
        out.close();
        return true;
    }

    protected static boolean isMetricsClass(ClassDoc doc) {
        String metricBaseFqn = MetricBase.class.getName();
        if (!doc.isClass()) {
            return false;
        }
        do {
            if ((doc = doc.superclass()) == null || !metricBaseFqn.equals(doc.qualifiedTypeName())) continue;
            return true;
        } while (doc != null);
        return false;
    }

    protected static PrintStream getOutput(RootDoc root) {
        for (String[] arg : root.options()) {
            if (!arg[0].equals("-f") || arg.length != 2) continue;
            try {
                return new PrintStream(new File(arg[1]));
            }
            catch (FileNotFoundException fnfe) {
                root.printError("Could not open destination file: " + arg[1]);
                fnfe.printStackTrace();
                return null;
            }
        }
        root.printError("Destination file parameter -f not supplied.");
        return null;
    }

    public static int optionLength(String option) {
        if (option.equals("-f")) {
            return 2;
        }
        return 0;
    }

    protected static String firstSentence(Doc doc) {
        Tag[] tags = doc.firstSentenceTags();
        StringBuilder builder = new StringBuilder(128);
        for (Tag tag : tags) {
            builder.append(tag.text());
        }
        return builder.toString();
    }
}

