### R code from vignette source 'RTN.Rnw'

###################################################
### code chunk number 1: Ropts
###################################################
options(width=70)


###################################################
### code chunk number 2: Load a sample dataset
###################################################
library(RTN)
data(dt4rtn)


###################################################
### code chunk number 3: Create a new TNI object
###################################################
#Input 1: 'gexp', a named gene expression matrix (samples on cols)
#Input 2: 'transcriptionFactors', a named vector with TF ids (3 TFs for quick demonstration!)
#Input 3: 'gexpIDs', an optional data frame with gene annotation (it can be used to remove duplicated genes)
rtni <- new("TNI", gexp=dt4rtn$gexp, 
            transcriptionFactors=dt4rtn$tfs[c("PTTG1","E2F2","FOXM1")]
            )
rtni<-tni.preprocess(rtni,gexpIDs=dt4rtn$gexpIDs)


###################################################
### code chunk number 4: Permutation
###################################################
rtni<-tni.permutation(rtni)


###################################################
### code chunk number 5: Bootstrap
###################################################
rtni<-tni.bootstrap(rtni) 


###################################################
### code chunk number 6: Run DPI filter
###################################################
rtni<-tni.dpi.filter(rtni) 


###################################################
### code chunk number 7: Check summary
###################################################
tni.get(rtni,what="summary")
refnet<-tni.get(rtni,what="refnet")
tnet<-tni.get(rtni,what="tnet")


###################################################
### code chunk number 8: Get graph
###################################################
g<-tni.graph(rtni)


###################################################
### code chunk number 9: Create a new TNA object (preprocess TNI-to-TNA)
###################################################
#Input 1: 'object', a TNI object with a pre-processed transcripional network
#Input 2: 'phenotype', a named numeric vector of phenotypes
#Input 3: 'hits', a character vector of gene ids considered as hits
#Input 4: 'phenoIDs', an optional data frame with anottation used to aggregate genes in the phenotype
rtna<-tni2tna.preprocess(object=rtni, 
                         phenotype=dt4rtn$pheno, 
                         hits=dt4rtn$hits, 
                         phenoIDs=dt4rtn$phenoIDs
                         )


###################################################
### code chunk number 10: Run MRA analysis pipeline
###################################################
rtna<-tna.mra(rtna)


###################################################
### code chunk number 11: Run overlap analysis pipeline
###################################################
rtna<-tna.overlap(rtna)


###################################################
### code chunk number 12: Run GSEA analysis pipeline
###################################################
rtna<-tna.gsea1(rtna)


###################################################
### code chunk number 13: Get results
###################################################
tna.get(rtna,what="summary")
tna.get(rtna,what="mra")
tna.get(rtna,what="overlap")
tna.get(rtna,what="gsea1")


###################################################
### code chunk number 14: Plot GSEA
###################################################
tna.plot.gsea1(rtna, width=6, height=4, 
              heightPanels=c(1,0.7,3), 
              ylimPanels=c(0,3.5,0,0.8), 
              labPheno="tna_test") 


###################################################
### code chunk number 15: Session information
###################################################
print(sessionInfo(), locale=FALSE)


