### R code from vignette source 'RRHO.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: RRHO.Rnw:84-92
###################################################
library(RRHO)
# Create "gene" lists:
  list.length <- 100
	list.names <- paste('Gene',1:list.length, sep='')
	gene.list1<- data.frame(list.names, sample(100))
	gene.list2<- data.frame(list.names, sample(100))
# Compute overlap and significance
	RRHO.example <-  RRHO(gene.list1, gene.list2, BY=TRUE)


###################################################
### code chunk number 2: RRHO.Rnw:95-98
###################################################
# Examine Nominal (-log) pvalues
  image(RRHO.example$hypermat)
# Note: If lattice is available try: levelplot(RRHO.example$hypermat)


###################################################
### code chunk number 3: RRHO.Rnw:101-107
###################################################
pval.testing <- pvalRRHO(RRHO.example,50)
# FWER corrected pvalue:
pval.testing$pval
# The sampling distribution of the minimum of the (-log) nominal p-values:
xs<- seq(0,10,length=100)
plot(Vectorize(pval.testing$FUN.ecdf)(xs)~xs, xlab='-log(pvalue)', ylab='ECDF', type='S')


###################################################
### code chunk number 4: RRHO.Rnw:112-115
###################################################
# Examine B-Y corrected pvalues 
# Note: probably nothing will be rejected in this example as the data is generated from the null.
  image(RRHO.example$hypermat.by)


