/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Permut
extends AbstractFunction {
    public Permut() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "n", "The total number of objects."), new ArgDescriptor(ArgType.INT, "k", "The size of the selected subset.")});
    }

    public String getName() {
        return "PERMUT";
    }

    public String getFunctionSummary() {
        return "Returns the number of permutations of size k of n objects.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        long N = FunctionUtil.getArgAsLong(args[0]);
        if (N <= 0L) {
            throw new IllegalArgumentException("first argument to PERMUT must be positive!");
        }
        long K = FunctionUtil.getArgAsLong(args[1]);
        if (K < 0L) {
            throw new IllegalArgumentException("second argument to PERMUT must be nonnegative!");
        }
        if (K > N) {
            throw new IllegalArgumentException("second argument to PERMUT must be no greater than the first argument!");
        }
        long retval = 1L;
        long multiplier = N;
        for (long i = 0L; i < K; ++i) {
            long next = retval * multiplier;
            if (next < retval) {
                throw new ArithmeticException("overflow detected while calulating PERMUT(" + N + "," + K + "!");
            }
            --multiplier;
            retval = next;
        }
        return retval;
    }
}

