/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.seq.io.agave.AGAVEMapLocation;
import org.biojava.bio.seq.io.agave.AGAVEMapPosition;
import org.biojava.bio.seq.io.agave.AGAVEMapPositionPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.seq.io.agave.StAXPropertyHandler;
import org.biojava.bio.seq.io.agave.UtilHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEMapLocationPropHandler
extends StAXPropertyHandler {
    public static final StAXHandlerFactory AGAVE_MAP_LOCATION_PROP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEMapLocationPropHandler(staxenv);
        }
    };
    private AGAVEMapLocation ml;

    AGAVEMapLocationPropHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.setHandlerCharacteristics("map_location", true);
        this.ml = new AGAVEMapLocation();
        super.addHandler(new ElementRecognizer.ByLocalName("map_position"), AGAVEMapPositionPropHandler.AGAVE_MAP_POSITION_PROP_HANDLER_FACTORY);
    }

    public void addMapPosition(AGAVEMapPosition pos) {
        this.ml.addPosition(pos);
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.ml.setMapType(attrs.getValue("map_type"));
        this.ml.setChromosome(attrs.getValue("chromsome"));
        this.ml.setUnits(attrs.getValue("units"));
        this.ml.setSource(attrs.getValue("source"));
        this.ml.setSubSeqStart(attrs.getValue("sebseq_start"));
        this.ml.setOrientation(attrs.getValue("orientation"));
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        try {
            Object ob = UtilHelper.getProperty(this.staxenv.featureTemplate.annotation, "map_location");
            if (ob != null) {
                ((List)ob).add(this.ml);
            } else {
                ArrayList<AGAVEMapLocation> mls = new ArrayList<AGAVEMapLocation>(1);
                mls.add(this.ml);
                this.staxenv.featureTemplate.annotation.setProperty("map_location", mls);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }
}

