/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.Taxon;

public interface OrthologueFilter {
    public boolean accept(Orthologue var1);

    public static class ByTitle
    implements OrthologueFilter {
        String regex;

        public ByTitle(String regex) {
            this.regex = regex;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return ortho.getTitle().matches(this.regex);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class ByAccession
    implements OrthologueFilter {
        String regex;

        public ByAccession(String regex) {
            this.regex = regex;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return ortho.getAccession().matches(this.regex);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class ByHomologeneID
    implements OrthologueFilter {
        String homologeneID;

        public ByHomologeneID(String homologeneID) {
            this.homologeneID = homologeneID;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return this.homologeneID.equals(ortho.getHomologeneID());
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class ByLocusID
    implements OrthologueFilter {
        String locusID;

        public ByLocusID(String locusID) {
            this.locusID = locusID;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return this.locusID.equals(ortho.getLocusID());
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class ByTaxon
    implements OrthologueFilter {
        Taxon taxon;

        public ByTaxon(Taxon taxon) {
            this.taxon = taxon;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return this.taxon == ortho.getTaxon();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class ByTaxonID
    implements OrthologueFilter {
        int taxonID;

        public ByTaxonID(int taxonID) {
            this.taxonID = taxonID;
        }

        public boolean accept(Orthologue ortho) {
            try {
                return this.taxonID == ortho.getTaxonID();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static final class Xor
    implements OrthologueFilter {
        OrthologueFilter a;
        OrthologueFilter b;

        public Xor(OrthologueFilter a, OrthologueFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(Orthologue ortho) {
            return this.a.accept(ortho) ^ this.b.accept(ortho);
        }
    }

    public static final class And
    implements OrthologueFilter {
        OrthologueFilter a;
        OrthologueFilter b;

        public And(OrthologueFilter a, OrthologueFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(Orthologue ortho) {
            return this.a.accept(ortho) && this.b.accept(ortho);
        }
    }

    public static final class Or
    implements OrthologueFilter {
        OrthologueFilter a;
        OrthologueFilter b;

        public Or(OrthologueFilter a, OrthologueFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(Orthologue ortho) {
            return this.a.accept(ortho) || this.b.accept(ortho);
        }
    }

    public static final class Not
    implements OrthologueFilter {
        OrthologueFilter a;

        public Not(OrthologueFilter a) {
            this.a = a;
        }

        public boolean accept(Orthologue ortho) {
            return !this.a.accept(ortho);
        }
    }

    public static final class AcceptAll
    implements OrthologueFilter {
        public boolean accept(Orthologue ortho) {
            return true;
        }
    }
}

