/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.util.ReadOnlyPropertyException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertySet {
    Set<Map.Entry<String, Object>> mapViewCore;

    protected PropertySet() {
    }

    protected abstract PropertyMap getPropertyMap();

    protected static PropertyMap parse(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<PropertyMap>(){

            @Override
            public PropertyMap run() {
                PropertyMap props = new PropertyMap();
                for (Class c = clazz; c != null; c = c.getSuperclass()) {
                    Property cp;
                    for (Field field : c.getDeclaredFields()) {
                        cp = field.getAnnotation(Property.class);
                        if (cp == null) continue;
                        for (String value : cp.value()) {
                            props.put(value, new FieldAccessor(field, value));
                        }
                    }
                    for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                        Method setter;
                        cp = ((Method)accessibleObject).getAnnotation(Property.class);
                        if (cp == null) continue;
                        String name = ((Method)accessibleObject).getName();
                        assert (name.startsWith("get"));
                        String setName = 's' + name.substring(1);
                        try {
                            setter = clazz.getMethod(setName, ((Method)accessibleObject).getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            setter = null;
                        }
                        for (String value : cp.value()) {
                            props.put(value, new MethodAccessor((Method)accessibleObject, setter, value));
                        }
                    }
                }
                return props;
            }
        });
    }

    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            return sp.get(this);
        }
        throw new IllegalArgumentException("Undefined property " + key);
    }

    public Object put(String key, Object value) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            Object old = sp.get(this);
            sp.set(this, value);
            return old;
        }
        throw new IllegalArgumentException("Undefined property " + key);
    }

    public boolean supports(Object key) {
        return this.getPropertyMap().containsKey(key);
    }

    public Object remove(Object key) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            Object old = sp.get(this);
            sp.set(this, null);
            return old;
        }
        throw new IllegalArgumentException("Undefined property " + key);
    }

    public final Map<String, Object> createMapView() {
        final HashSet<Map.Entry<String, Object>> core = new HashSet<Map.Entry<String, Object>>();
        this.createEntrySet(core);
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return core;
            }
        };
    }

    void createEntrySet(Set<Map.Entry<String, Object>> core) {
        for (final Map.Entry e : this.getPropertyMap().entrySet()) {
            core.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)e.getKey();
                }

                @Override
                public Object getValue() {
                    return ((Accessor)e.getValue()).get(PropertySet.this);
                }

                @Override
                public Object setValue(Object value) {
                    Accessor acc = (Accessor)e.getValue();
                    Object old = acc.get(PropertySet.this);
                    acc.set(PropertySet.this, value);
                    return old;
                }
            });
        }
    }

    static final class MethodAccessor
    implements Accessor {
        @NotNull
        private final Method getter;
        @Nullable
        private final Method setter;
        private final String name;

        protected MethodAccessor(Method getter, Method setter, String value) {
            this.getter = getter;
            this.setter = setter;
            this.name = value;
            getter.setAccessible(true);
            if (setter != null) {
                setter.setAccessible(true);
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue(PropertySet props) {
            return this.get(props) != null;
        }

        public Object get(PropertySet props) {
            try {
                return this.getter.invoke((Object)props, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            catch (InvocationTargetException e) {
                this.handle(e);
                return 0;
            }
        }

        public void set(PropertySet props, Object value) {
            if (this.setter == null) {
                throw new ReadOnlyPropertyException(this.getName());
            }
            try {
                this.setter.invoke((Object)props, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            catch (InvocationTargetException e) {
                this.handle(e);
            }
        }

        private Exception handle(InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Error(e);
        }
    }

    static final class FieldAccessor
    implements Accessor {
        private final Field f;
        private final String name;

        protected FieldAccessor(Field f, String name) {
            this.f = f;
            f.setAccessible(true);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue(PropertySet props) {
            return this.get(props) != null;
        }

        public Object get(PropertySet props) {
            try {
                return this.f.get(props);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }

        public void set(PropertySet props, Object value) {
            try {
                this.f.set(props, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }

    protected static interface Accessor {
        public String getName();

        public boolean hasValue(PropertySet var1);

        public Object get(PropertySet var1);

        public void set(PropertySet var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class PropertyMap
    extends HashMap<String, Accessor> {
        protected PropertyMap() {
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Property {
        public String[] value();
    }
}

