/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.ShapeLayer;
import com.sun.glf.goodies.ColorCompositeContext;
import com.sun.glf.goodies.ColorCompositeRule;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ColorComposite
implements Composite {
    private ColorCompositeRule rule;
    private float alpha;
    public static final ColorComposite Hue = new ColorComposite(ColorCompositeRule.HUE, 1.0f);
    public static final ColorComposite Brightness = new ColorComposite(ColorCompositeRule.BRIGHTNESS, 1.0f);
    public static final ColorComposite Saturation = new ColorComposite(ColorCompositeRule.SATURATION, 1.0f);
    public static final ColorComposite Hs = new ColorComposite(ColorCompositeRule.COLOR, 1.0f);
    static final String USAGE = "java com.sun.glf.goodies.ColorComposite <imageFile> <red> <green> <blue>";

    public static ColorComposite getInstance(ColorCompositeRule colorCompositeRule, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Out of range alpha: " + f + ". Should be between 0 and 1");
        }
        if (colorCompositeRule == null) {
            throw new IllegalArgumentException("rule should not be null");
        }
        if (f == 1.0f) {
            switch (colorCompositeRule.toInt()) {
                case 0: {
                    return Hue;
                }
                case 1: {
                    return Saturation;
                }
                case 2: {
                    return Brightness;
                }
                case 3: {
                    return Hs;
                }
            }
            throw new Error("Unknown ColorCompositeRule");
        }
        return new ColorComposite(colorCompositeRule, f);
    }

    protected ColorComposite(ColorCompositeRule colorCompositeRule, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Out of range alpha: " + f + ". Should be between 0 and 1");
        }
        if (colorCompositeRule == null) {
            throw new IllegalArgumentException("rule should not be null");
        }
        this.alpha = f;
        this.rule = colorCompositeRule;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return new ColorCompositeContext(this.rule, this.alpha, colorModel, colorModel2, renderingHints);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public ColorCompositeRule getRule() {
        return this.rule;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println(USAGE);
            System.exit(0);
        }
        Image image = null;
        Color color = null;
        if (stringArray.length < 4) {
            image = ColorComposite.buildTestImage();
            color = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else {
            image = Toolbox.loadImage(stringArray[0], 10);
            color = new Color(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }
        JFrame jFrame = new JFrame("ColorComposite unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 4));
        jFrame.getContentPane().setBackground(Color.white);
        ColorComposite[] colorCompositeArray = new ColorComposite[]{ColorComposite.getInstance(ColorCompositeRule.HUE, 1.0f), ColorComposite.getInstance(ColorCompositeRule.SATURATION, 1.0f), ColorComposite.getInstance(ColorCompositeRule.BRIGHTNESS, 1.0f), ColorComposite.getInstance(ColorCompositeRule.COLOR, 1.0f), ColorComposite.getInstance(ColorCompositeRule.HUE, 0.75f), ColorComposite.getInstance(ColorCompositeRule.SATURATION, 0.75f), ColorComposite.getInstance(ColorCompositeRule.BRIGHTNESS, 0.75f), ColorComposite.getInstance(ColorCompositeRule.COLOR, 0.75f), ColorComposite.getInstance(ColorCompositeRule.HUE, 0.2f), ColorComposite.getInstance(ColorCompositeRule.SATURATION, 0.2f), ColorComposite.getInstance(ColorCompositeRule.BRIGHTNESS, 0.2f), ColorComposite.getInstance(ColorCompositeRule.COLOR, 0.2f)};
        String[] stringArray2 = new String[]{"Hue", "Saturation", "Brightness", "Color", "Hue, 75% transparent", "Saturation, 75% transparent", "Brightness, 75% transparent", "Color, 75% transparent", "Hue, 50% transparent", "Saturation, 50% transparent", "Brightness, 50% transparent", "Color, 50% transparent"};
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        for (int i = 0; i < colorCompositeArray.length; ++i) {
            JComponent jComponent = ColorComposite.makeNewComponent(dimension, image, color, colorCompositeArray[i]);
            jComponent.setToolTipText(stringArray2[i]);
            jFrame.getContentPane().add(jComponent);
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static JComponent makeNewComponent(Dimension dimension, Image image, Color color, Composite composite) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, layerComposition.getBounds(), new FillRenderer(color));
        ImageLayer imageLayer = new ImageLayer(layerComposition, image, null);
        imageLayer.setComposite(composite);
        layerComposition.setLayers(new Layer[]{shapeLayer, imageLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        return compositionComponent;
    }

    public static Image buildTestImage() {
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue, Color.black, Color.gray, Color.white, Color.cyan, Color.magenta, Color.yellow};
        int n = 15;
        BufferedImage bufferedImage = new BufferedImage(n * 3, n * 3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < colorArray.length / 3; ++i) {
            graphics2D.setColor(colorArray[3 * i]);
            graphics2D.fillRect(0, 0, n, n);
            graphics2D.setColor(colorArray[3 * i + 1]);
            graphics2D.fillRect(n, 0, n, n);
            graphics2D.setColor(colorArray[3 * i + 2]);
            graphics2D.fillRect(2 * n, 0, n, n);
            graphics2D.translate(0, n);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

