### R code from vignette source 'FGNet-vignette.Rnw'

###################################################
### code chunk number 1: FGNet-vignette.Rnw:88-90 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("FGNet")


###################################################
### code chunk number 2: FGNet-vignette.Rnw:102-110
###################################################
library(FGNet)
genesYeast <- c("ADA2", "APC1", "APC11", "APC2", "APC4", "APC5", "APC9", 
"CDC16", "CDC23", "CDC26", "CDC27", "CFT1", "CFT2", "DCP1", "DOC1", "FIP1", 
"GCN5", "GLC7", "HFI1", "KEM1", "LSM1", "LSM2", "LSM3", "LSM4", "LSM5", 
"LSM6", "LSM7", "LSM8", "MPE1", "NGG1", "PAP1", "PAT1", "PFS2", "PTA1", 
"PTI1", "REF2", "RNA14", "RPN1", "RPN10", "RPN11", "RPN13", "RPN2", "RPN3",
"RPN5", "RPN6", "RPN8", "RPT1", "RPT3", "RPT6", "SGF11", "SGF29", "SGF73",
"SPT20", "SPT3", "SPT7", "SPT8", "TRA1", "YSH1", "YTH1")


###################################################
### code chunk number 3: FGNet-vignette.Rnw:114-115 (eval = FALSE)
###################################################
## report_david(genesYeast[1:15], geneIdType="GENE_SYMBOL")


###################################################
### code chunk number 4: FGNet-vignette.Rnw:119-120 (eval = FALSE)
###################################################
## report_gtLinker(genesYeast, organism = "Sc")


###################################################
### code chunk number 5: FGNet-vignette.Rnw:148-149 (eval = FALSE)
###################################################
## report_gtLinker(jobID=1639610, jobName="Alzheimer")


###################################################
### code chunk number 6: FGNet-vignette.Rnw:153-155 (eval = FALSE)
###################################################
## report_gtLinker(jobID=1639610, jobName="Alzheimer_trh0.2",
## threshold=0.2)


###################################################
### code chunk number 7: FGNet-vignette.Rnw:161-162 (eval = FALSE)
###################################################
## ?report_gtLinker


###################################################
### code chunk number 8: FGNet-vignette.Rnw:183-192 (eval = FALSE)
###################################################
## genesYeast <- c("ADA2", "APC1", "APC11", "APC2", "APC4", "APC5", "APC9", 
## "CDC16", "CDC23", "CDC26", "CDC27", "CFT1", "CFT2", "DCP1", "DOC1", "FIP1", 
## "GCN5", "GLC7", "HFI1", "KEM1", "LSM1", "LSM2", "LSM3", "LSM4", "LSM5", 
## "LSM6", "LSM7", "LSM8", "MPE1", "NGG1", "PAP1", "PAT1", "PFS2", "PTA1", 
## "PTI1", "REF2", "RNA14", "RPN1", "RPN10", "RPN11", "RPN13", "RPN2", "RPN3",
## "RPN5", "RPN6", "RPN8", "RPT1", "RPT3", "RPT6", "SGF11", "SGF29", "SGF73",
## "SPT20", "SPT3", "SPT7", "SPT8", "TRA1", "YSH1", "YTH1")
## organism <- "Sc"
## jobID <- query_gtLinker(genesYeast, organism=organism)


###################################################
### code chunk number 9: FGNet-vignette.Rnw:195-196
###################################################
	jobID <- 3907019


###################################################
### code chunk number 10: FGNet-vignette.Rnw:201-206
###################################################
annotations <- c("GO_Biological_Process", 
"GO_Molecular_Function", 
"GO_Cellular_Component", 
"KEGG_Pathways", 
"InterPro_Motifs")


###################################################
### code chunk number 11: FGNet-vignette.Rnw:210-211 (eval = FALSE)
###################################################
## ?query_david


###################################################
### code chunk number 12: FGNet-vignette.Rnw:219-220
###################################################
results <- getResults_gtLinker(jobID, jobName="Set4yeast")


###################################################
### code chunk number 13: FGNet-vignette.Rnw:223-225 (eval = FALSE)
###################################################
## results <- getResults_gtLinker(jobName="Set4yeast", 
## alreadyDownloaded=TRUE)


###################################################
### code chunk number 14: FGNet-vignette.Rnw:229-230
###################################################
names(results)


###################################################
### code chunk number 15: FGNet-vignette.Rnw:232-233
###################################################
head(results$metagroups)


###################################################
### code chunk number 16: FGNet-vignette.Rnw:237-238 (eval = FALSE)
###################################################
## ?getResults_david


###################################################
### code chunk number 17: FGNet-vignette.Rnw:245-246
###################################################
adjMat <- adjMatrix(results$geneTermSets)


###################################################
### code chunk number 18: FGNet-vignette.Rnw:249-251
###################################################
head(adjMat$metagroupGenesMatrix)
adjMat$gtSetGenesMatrix[1:5, 14:18]


###################################################
### code chunk number 19: FGNet-vignette.Rnw:254-256
###################################################
adjMatFiltered <- adjMatrix(results$geneTermSets, 
attribute=results$metagroups[,"Silhouette Width", drop=FALSE], threshold=0.2)


###################################################
### code chunk number 20: FGNet-vignette.Rnw:259-260
###################################################
adjMatFiltered$filteredOut


###################################################
### code chunk number 21: FGNet-vignette.Rnw:267-268
###################################################
functionalNetwork(adjMat) 


###################################################
### code chunk number 22: FGNet-vignette.Rnw:272-273 (eval = FALSE)
###################################################
## functionalNetwork(adjMat, plotType="dynamic") 


###################################################
### code chunk number 23: FGNet-vignette.Rnw:277-278
###################################################
fNw <- functionalNetwork(adjMat, returnGraph=TRUE, plotType="none") 


###################################################
### code chunk number 24: FGNet-vignette.Rnw:282-284
###################################################
library(igraph)
fNw


###################################################
### code chunk number 25: FGNet-vignette.Rnw:286-287
###################################################
str(fNw)


###################################################
### code chunk number 26: FGNet-vignette.Rnw:289-292
###################################################
vcount(fNw)
ecount(fNw)
sort(betweenness(fNw), decreasing=TRUE)[1:30]


###################################################
### code chunk number 27: FGNet-vignette.Rnw:295-296
###################################################
igraph.to.graphNEL(fNw)


###################################################
### code chunk number 28: FGNet-vignette.Rnw:300-304 (eval = FALSE)
###################################################
## functionalNetwork(adjMatFiltered, plotType="dynamic") 
## # Modify the layout...
## saveLayout <- tkplot.getcoords(1)   # tkp.id (ID of the tkplot window)
## functionalNetwork(adjMatFiltered, vLayout=saveLayout)


###################################################
### code chunk number 29: FGNet-vignette.Rnw:311-313
###################################################
intersectionNetwork(adjMat, 
 plotType="static", vLayout="kk")


###################################################
### code chunk number 30: FGNet-vignette.Rnw:318-319
###################################################
getTerms(results)[1]


###################################################
### code chunk number 31: FGNet-vignette.Rnw:327-337
###################################################
genesMetabolism <- c("YGR175C", "YHR007C", "YMR202W", "YJL167W", 
"YNL280C", "YGR060W", "YGL001C", "YLR100W", "YLR056W", "YGL012W", 
"YMR015C", "YML008C", "YHR072W", "YHR190W", "YKL004W", "YBR036C", 
"YDR294C", "YDR072C", "YKL008C", "YHL003C", "YMR296C", "YDR062W", 
"YJL134W", "YOR171C", "YLR260W", "YMR298W", "YMR272C", "YPL057C",
"YDR297W", "YBR265W", "YPL087W", "YBR183W", "YKR053C")
# To add the gene label/symbol for the plots...
library(org.Sc.sgd.db)
geneLabels <- unlist(as.list(org.Sc.sgdGENENAME)[genesMetabolism])
names(genesMetabolism) <- geneLabels 


###################################################
### code chunk number 32: FGNet-vignette.Rnw:343-344 (eval = FALSE)
###################################################
## report_david(inputFileLocation="http://david... .txt")


###################################################
### code chunk number 33: FGNet-vignette.Rnw:348-349 (eval = FALSE)
###################################################
## report_david(genesMetabolism, email="...", geneLabels=genesMetabolism)


###################################################
### code chunk number 34: FGNet-vignette.Rnw:353-354 (eval = FALSE)
###################################################
## report_david(genesMetabolism)


###################################################
### code chunk number 35: FGNet-vignette.Rnw:361-366
###################################################
txtFile <- query_david(genesMetabolism, email="FGNet.pkg@email.com")
results <- getResults_david(txtFile, jobName="David_Metabolism",
 geneLabels=genesMetabolism)
adjMat <- adjMatrix(results$geneTermSets)
functionalNetwork(adjMat) 


###################################################
### code chunk number 36: FGNet-vignette.Rnw:368-372 (eval = FALSE)
###################################################
## txtFile <- query_david(genesMetabolism, email="...")
## results <- getResults_david(txtFile, jobName="David_Metabolism", geneLabels=genesMetabolism)
## adjMat <- adjMatrix(results$geneTermSets)
## #functionalNetwork(adjMat) 


###################################################
### code chunk number 37: FGNet-vignette.Rnw:377-379 (eval = FALSE)
###################################################
## getAllAnnotationCategoryNames(DAVIDWebService$new(email="..."))
## getIdTypes(DAVIDWebService$new(email="..."))


###################################################
### code chunk number 38: FGNet-vignette.Rnw:383-384
###################################################
getTerms(results)[5]


###################################################
### code chunk number 39: FGNet-vignette.Rnw:388-389
###################################################
distMat <- plotMetagroupsDistance(adjMat$metagroupGenesMatrix)


###################################################
### code chunk number 40: FGNet-vignette.Rnw:396-398
###################################################
colnames(results$clusters)
quantile(results$clusters$EnrichmentScore, c(0.10, 0.25, 0.5, 0.75, 0.9))


###################################################
### code chunk number 41: FGNet-vignette.Rnw:400-403
###################################################
adjMatFiltered <- adjMatrix(results$geneTermSets, 
 attribute=results$clusters[,"EnrichmentScore", drop=FALSE], threshold=10)
functionalNetwork(adjMatFiltered)


###################################################
### code chunk number 42: FGNet-vignette.Rnw:407-411
###################################################
quantile(results$clusters$nGenes, c(0.10, 0.25, 0.5, 0.75, 0.9))
adjMatFiltered <- adjMatrix(results$geneTermSets, 
 attribute=-(results$clusters[,"nGenes", drop=FALSE]), threshold=-15)
functionalNetwork(adjMatFiltered)


###################################################
### code chunk number 43: FGNet-vignette.Rnw:417-429
###################################################
keywords <- c("sphingolipid") 
selectedClusters <- sapply(getTerms(results), 
 function(x) 
 any(grep(paste("(", paste(keywords, collapse="|") ,")",sep=""), tolower(x))))
resultsSclusters <- results
resultsSclusters$clusters <- cbind(resultsSclusters$clusters, 
 selectedKeywords=as.numeric(selectedClusters))
adjMatSelectedGroups <- adjMatrix(resultsSclusters$geneTermSets, 
 attribute=resultsSclusters$clusters[,"selectedKeywords", drop=FALSE], 
 threshold=1)
functionalNetwork(adjMatSelectedGroups)
getTerms(results)[selectedClusters]


###################################################
### code chunk number 44: FGNet-vignette.Rnw:433-443
###################################################
selectedClusters <- rep(FALSE, nrow(results$clusters))
selectedClusters[c(2,9,11)] <- TRUE

resultsSclusters <- results
resultsSclusters$clusters <- cbind(resultsSclusters$clusters, 
 selectedClusters=as.numeric(selectedClusters))
adjMatSelectedGroups <- adjMatrix(resultsSclusters$geneTermSets, 
 attribute=resultsSclusters$clusters[,"selectedClusters", drop=FALSE], 
 threshold=1)
functionalNetwork(adjMatSelectedGroups)


