### R code from vignette source 'DiffBind.Rnw'

###################################################
### code chunk number 1: DiffBind.Rnw:102-107
###################################################
tmp =  tempfile(as.character(Sys.getpid()))
pdf(tmp)
savewarn = options("warn")
options(warn=-1)
savewd = getwd()


###################################################
### code chunk number 2: DiffBind.Rnw:110-112
###################################################
library(DiffBind)
setwd(system.file("extra", package="DiffBind"))


###################################################
### code chunk number 3: DiffBind.Rnw:117-122 (eval = FALSE)
###################################################
## tamoxifen = dba(sampleSheet="tamoxifen.csv")
## tamoxifen = dba.count(tamoxifen)
## tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)
## tamoxifen = dba.analyze(tamoxifen)
## tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 4: DiffBind.Rnw:154-155
###################################################
tamoxifen = dba(sampleSheet="tamoxifen.csv")


###################################################
### code chunk number 5: DiffBind.Rnw:160-161
###################################################
tamoxifen


###################################################
### code chunk number 6: DiffBind.Rnw:173-174 (eval = FALSE)
###################################################
## plot(tamoxifen)


###################################################
### code chunk number 7: DiffBind.Rnw:190-191 (eval = FALSE)
###################################################
## tamoxifen = dba.count(tamoxifen, minOverlap=3) 


###################################################
### code chunk number 8: DiffBind.Rnw:194-195
###################################################
data(tamoxifen_counts)


###################################################
### code chunk number 9: DiffBind.Rnw:204-205
###################################################
tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)


###################################################
### code chunk number 10: DiffBind.Rnw:225-226
###################################################
tamoxifen = dba.analyze(tamoxifen) 


###################################################
### code chunk number 11: DiffBind.Rnw:236-237
###################################################
tamoxifen    


###################################################
### code chunk number 12: DiffBind.Rnw:253-254
###################################################
tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 13: DiffBind.Rnw:259-260
###################################################
tamoxifen.DB


###################################################
### code chunk number 14: DiffBind.Rnw:279-280
###################################################
dba.plotMA(tamoxifen)


###################################################
### code chunk number 15: DiffBind.Rnw:299-300
###################################################
dba.plotPCA(tamoxifen,DBA_CONDITION)


###################################################
### code chunk number 16: DiffBind.Rnw:319-320
###################################################
dba.plotPCA(tamoxifen, contrast=1,th=.05)


###################################################
### code chunk number 17: DiffBind.Rnw:338-340
###################################################
sum(tamoxifen.DB$Fold<0)
sum(tamoxifen.DB$Fold>0)


###################################################
### code chunk number 18: DiffBind.Rnw:345-346
###################################################
pvals = dba.plotBox(tamoxifen)


###################################################
### code chunk number 19: DiffBind.Rnw:360-361
###################################################
pvals


###################################################
### code chunk number 20: DiffBind.Rnw:378-379
###################################################
corvals = dba.plotHeatmap(tamoxifen)


###################################################
### code chunk number 21: DiffBind.Rnw:386-387
###################################################
corvals = dba.plotHeatmap(tamoxifen, contrast=1, correlations=FALSE)


###################################################
### code chunk number 22: DiffBind.Rnw:408-411
###################################################
data(tamoxifen_counts)
tamoxifen = dba.contrast(tamoxifen,categories=DBA_CONDITION,
                         block=tamoxifen$masks$MCF7)


###################################################
### code chunk number 23: DiffBind.Rnw:416-418
###################################################
tamoxifen = dba.analyze(tamoxifen)
tamoxifen


###################################################
### code chunk number 24: DiffBind.Rnw:427-428
###################################################
dba.plotMA(tamoxifen,method=DBA_EDGER_BLOCK)


###################################################
### code chunk number 25: DiffBind.Rnw:443-445
###################################################
dba.plotHeatmap(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
                attributes=c(DBA_TISSUE,DBA_CONDITION,DBA_REPLICATE))


###################################################
### code chunk number 26: DiffBind.Rnw:448-450
###################################################
dba.plotPCA(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
            attributes=c(DBA_TISSUE,DBA_CONDITION))


###################################################
### code chunk number 27: DiffBind.Rnw:470-472
###################################################
tamoxifen = dba.analyze(tamoxifen,method=DBA_ALL_METHODS)
tamoxifen


###################################################
### code chunk number 28: DiffBind.Rnw:482-485
###################################################
tam.block = dba.report(tamoxifen,method=DBA_ALL_BLOCK,bDB=TRUE,bAll=TRUE)
tam.block
dba.plotVenn(tam.block,1:3,label1="edgeR",label2="DESeq",label3="DESeq2")


###################################################
### code chunk number 29: DiffBind.Rnw:503-504
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 30: DiffBind.Rnw:520-522
###################################################
olap.rate = dba.overlap(tamoxifen,mode=DBA_OLAP_RATE)
olap.rate


###################################################
### code chunk number 31: DiffBind.Rnw:530-531
###################################################
plot(olap.rate,type='b',ylab='# peaks', xlab='Overlap at least this many peaksets') 


###################################################
### code chunk number 32: DiffBind.Rnw:549-550
###################################################
names(tamoxifen$masks)


###################################################
### code chunk number 33: DiffBind.Rnw:555-557
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive,
            mode=DBA_OLAP_RATE)


###################################################
### code chunk number 34: DiffBind.Rnw:568-569
###################################################
dba.plotVenn(tamoxifen, tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive)


###################################################
### code chunk number 35: DiffBind.Rnw:587-590
###################################################
tamoxifen = dba.peakset(tamoxifen, consensus = c(DBA_TISSUE,DBA_CONDITION), 
            minOverlap=0.66)
tamoxifen


###################################################
### code chunk number 36: DiffBind.Rnw:598-600
###################################################
tamoxifen_consensus = dba(tamoxifen, mask = tamoxifen$masks$Consensus)
tamoxifen_consensus


###################################################
### code chunk number 37: DiffBind.Rnw:616-619 (eval = FALSE)
###################################################
## data(tamoxifen_peaks)
## tamoxifen = dba.peakset(tamoxifen, consensus = DBA_TISSUE, minOverlap=0.66)
## dba.plotVenn(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 38: DiffBind.Rnw:628-629
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 39: DiffBind.Rnw:634-636
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$Resistant,mode=DBA_OLAP_RATE)
dba.overlap(tamoxifen,tamoxifen$masks$Responsive,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 40: DiffBind.Rnw:648-650
###################################################
tamoxifen = dba.peakset(tamoxifen, consensus =  DBA_CONDITION, minOverlap = 0.33)
dba.plotVenn(tamoxifen,tamoxifen$masks$Consensus)


###################################################
### code chunk number 41: DiffBind.Rnw:672-673
###################################################
tamoxifen.OL = dba.overlap(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 42: DiffBind.Rnw:678-680
###################################################
tamoxifen.OL$onlyA
tamoxifen.OL$onlyB


###################################################
### code chunk number 43: DiffBind.Rnw:692-697
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Consensus, 
            minOverlap=1,sampID="OL Consensus")
tamoxifen = dba.peakset(tamoxifen,!tamoxifen$masks$Consensus,
            minOverlap=3,sampID="Consensus_3") 
dba.plotVenn(tamoxifen,14:15)


###################################################
### code chunk number 44: DiffBind.Rnw:712-713
###################################################
data(tamoxifen_analysis)


###################################################
### code chunk number 45: DiffBind.Rnw:718-719
###################################################
tamoxifen.rep = dba.report(tamoxifen,bCalled=T,th=1)


###################################################
### code chunk number 46: DiffBind.Rnw:724-730
###################################################
onlyResistant = tamoxifen.rep$Called1>=2 & tamoxifen.rep$Called2<3
sum(onlyResistant )
onlyResponsive = tamoxifen.rep$Called2>=3 &  tamoxifen.rep$Called1<2
sum(onlyResponsive)
bothGroups = tamoxifen.rep$Called1>= 2 & tamoxifen.rep$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 47: DiffBind.Rnw:746-753
###################################################
tamoxifen.DB = dba.report(tamoxifen,bCalled=T,th=.1)
onlyResistant.DB = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2<3
sum(onlyResistant.DB)
onlyResponsive.DB = tamoxifen.DB$Called2>=3 & tamoxifen.DB$Called1<2
sum(onlyResponsive.DB)
bothGroups.DB = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2>=3
sum(bothGroups.DB)


###################################################
### code chunk number 48: DiffBind.Rnw:896-897 (eval = FALSE)
###################################################
## source(file.path(system.file("extra", package="DiffBind"),"tamoxifen_GEO.R"))


###################################################
### code chunk number 49: DiffBind.Rnw:904-905 (eval = FALSE)
###################################################
## cat(file.path(system.file("extra", package="DiffBind"),"tamoxifen_GEO.csv"))


###################################################
### code chunk number 50: setup
###################################################
sessionInfo()


###################################################
### code chunk number 51: DiffBind.Rnw:920-923
###################################################
dev.off()
unlink(tmp)
setwd(savewd)


