
## ----include=FALSE-------------------------------------------------------
library(DOSE)
library(clusterProfiler)
library(knitr)
opts_chunk$set(tidy=TRUE,tidy.opts=list(keep.blank.line=FALSE, width.cutoff=50),out.truncate=80,out.lines=6,cache=TRUE,dev='pdf',include=TRUE,fig.width=6,fig.height=6,resolution=150)


## ----options,results='hide',echo=FALSE-----------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")


## ----loading, eval=FALSE, results='hide'---------------------------------
## library(DOSE)
## help(DOSE)


## ----doSim---------------------------------------------------------------
data(DO2EG)
set.seed(123)
a <- sample(names(DO2EG), 10)
a
b <- sample(names(DO2EG), 5)
b
doSim(a[1], b[1], measure="Wang")
doSim(a[1], b[1], measure="Resnik")
doSim(a[1], b[1], measure="Lin")
s <- doSim(a, b, measure="Wang")
s


## ----simplot, fig.cap="Visualizing similarity matrix.", fig.align="center", fig.height=6, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
simplot(s, 
		color.low="white", color.high="red", 
		labs=TRUE, digits=2, labs.size=5, 
		font.size=14, xlab="", ylab="")


## ----geneSim-------------------------------------------------------------
data(EG2DO)
g1 <- sample(names(EG2DO), 5)
g1
g2 <- sample(names(EG2DO), 4)
g2
geneSim(g1[1], g2[1], measure="Wang", combine="BMA")
gs <- geneSim(g1, g2, measure="Wang", combine="BMA")
gs


## ----enrichment analysis-------------------------------------------------
data(geneList)
gene <- names(geneList)[abs(geneList) > 1]
head(gene)
x <- enrichDO(gene, ont="DOLite", 
		pvalueCutoff=0.05, pAdjustMethod="BH",
		universe = names(geneList), 
		minGSSize = 5, readable=FALSE)
head(summary(x))


## ----setReadable---------------------------------------------------------
x <- setReadable(x)
head(summary(x))


## ----barplot, fig.cap="barplot of DO enrichment result.", fig.align="center", fig.height=5, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
barplot(x)


## ----cnetplot, fig.cap="cnetplot of DO enrichment result.", fig.align="center", fig.height=16, fig.width=16, fig.pos="h"----
cnetplot(x, categorySize="pvalue", foldChange=geneList)


## ----clusterProfiler, fig.cap="DOSE with clusterProfiler.", fig.align="center", fig.height=6, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
require(clusterProfiler)
data(gcSample)
cdo <- compareCluster(gcSample, fun="enrichDO")
plot(cdo)


## ----GSEA analysis-------------------------------------------------------
y <- gseAnalyzer(geneList, setType="DOLite", nPerm=100, 
                  minGSSize=120, pvalueCutoff=0.05, 
                  pAdjustMethod="BH", verbose=FALSE)
res <- summary(y)
head(res)


## ----gseaplot, fig.cap="gseaplot example.", fig.align="center", fig.height=6, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
topID <- res[1,1]
topID
plot(y, geneSetID = topID)


## ----gseaplot2, eval=FALSE-----------------------------------------------
## plot(y, geneSetID = 1)


## ----sessInfo, results='asis', echo=FALSE--------------------------------
toLatex(sessionInfo())


