### R code from vignette source 'DNaseR.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width=80)
options(continue=" ")
options(prompt="R> ")


###################################################
### code chunk number 2: DNase I footprinting analysis of DNase-seq data in Bioconductor. Example 1
###################################################
options(width=80)

## hg18. chrY:1 - 3000Kb reads from DNase-seq dataset wgEncodeUwDgfTh1Aln.bam
## from the ENCODE Project.
##
## Downloaded from:
## http://hgdownload-test.cse.ucsc.edu/goldenPath/hg19/encodeDCC/wgEncodeUwDgf/
## release1/wgEncodeUwDgfTh1Aln.bam

owd <- setwd(tempdir())

library(DNaseR)

bamfile <- "chrY_3Kb_wgEncodeUwDgfTh1Aln.bam"

f <- system.file("extdata", bamfile, package="DNaseR",mustWork = TRUE)


dgf <- footprints(bam=f, chrN="chrY", chrL=3e6, p=1e-9, width=c(6,40), N=2e6)


head(dgf$footprint.events)

nrow(dgf$footprint.events)

setwd(owd)


###################################################
### code chunk number 3: DNase I footprinting analysis of DNase-seq data in Bioconductor. Example 2
###################################################
options(width=80)
owd <- setwd(tempdir())
library(DNaseR)
bamfile <- "chrY_3Kb_wgEncodeUwDgfTh1Aln.bam"
f <- system.file("extdata", bamfile, package="DNaseR",mustWork = TRUE)
dgf <- footprints(bam=f, chrN="chrY", chrL=3e6, p=1e-7, width=c(6,40), N=2e6)
head(dgf$footprint.events)
nrow(dgf$footprint.events)
setwd(owd)


###################################################
### code chunk number 4: DNase I footprinting analysis of DNase-seq data in Bioconductor. Example 3
###################################################
options(width=80)
owd <- setwd(tempdir())
library(DNaseR)
bamfile <- "chrY_3Kb_wgEncodeUwDgfTh1Aln.bam"
f <- system.file("extdata", bamfile, package="DNaseR",mustWork = TRUE)
dgf <- footprints(bam=f, chrN="chrY", chrL=3e6, p=1e-9, width=c(15,15), N=2e6)
head(dgf$footprint.events)
nrow(dgf$footprint.events)
setwd(owd)


###################################################
### code chunk number 5: sessionInfo
###################################################
sessionInfo()


