### R code from vignette source 'DesignProbes.Rnw'

###################################################
### code chunk number 1: DesignProbes.Rnw:51-53
###################################################
options(continue=" ")
options(width=60)


###################################################
### code chunk number 2: expr0 (eval = FALSE)
###################################################
## system("hybrid-min -V")


###################################################
### code chunk number 3: startup
###################################################
library(DECIPHER)


###################################################
### code chunk number 4: expr1
###################################################
# specify the path to your sequence file:
gb <- "<<path to GenBank file>>"
# OR find the example sequence file used in this tutorial:
gb <- system.file("extdata", "Bacteria_175seqs.gen", package="DECIPHER")


###################################################
### code chunk number 5: expr2
###################################################
# specify a path for where to write the sequence database
dbConn <- "<<path to write sequence database>>"
# OR create the sequence database in memory
dbConn <- dbConnect(SQLite(), ":memory:")
Seqs2DB(gb, "GenBank", dbConn, "Bacteria")


###################################################
### code chunk number 6: expr3
###################################################
ids <- IdentifyByRank(dbConn, level=Inf, add2tbl=TRUE)


###################################################
### code chunk number 7: expr4 (eval = FALSE)
###################################################
## tiles <- TileSeqs(dbConn, add2tbl="Tiles")


###################################################
### code chunk number 8: expr5 (eval = FALSE)
###################################################
## probes <- DesignProbes(tiles, identifier="Sphingopyxis",
## 	start=120, end=1450)


###################################################
### code chunk number 9: expr6 (eval = FALSE)
###################################################
## o <- order(probes$score, decreasing=TRUE)
## probes[o[1],]


###################################################
### code chunk number 10: expr7 (eval = FALSE)
###################################################
## ConsensusSequence(DNAStringSet(probes[o[1], "probe"][1:3]))


###################################################
### code chunk number 11: expr8 (eval = FALSE)
###################################################
## FA_range <- 0:70 # [FA] (%, v/v)
## probe <- probes$probe[o[1], 1:3]
## targets <- reverseComplement(DNAStringSet(probe))
## f <- function(FA)
## 	CalculateEfficiencyFISH(probe, targets,
## 		temp=46, P=250e-9, ions=1, FA)[, "HybEff"]
## efficiency <- matrix(unlist(lapply(FA_range, f)), ncol=3, byrow=TRUE)
## matplot(FA_range, efficiency, ylim=c(0,1), ylab="Hybridization Efficiency",
## 	xlab=expression(paste("[Formamide] (%, v/v)", sep="")),
## 	type="l", lwd=2, col="Blue", main="Formamide Curve", lty=1)
## 
## nontargets <- DNAStringSet(c("AGCGTTTGACATCCTGATCGCGG",
## 	"AGCTTTTGACATCCCGGTCGCGG"))
## f <- function(FA)
## 	CalculateEfficiencyFISH(probe[3:2], nontargets,
## 		temp=46, P=250e-9, ions=1, FA)[, "HybEff"]
## efficiency <- matrix(unlist(lapply(FA_range, f)), ncol=2, byrow=TRUE)
## matlines(FA_range, efficiency, col="Red", lwd=2, lty=3)
## 
## abline(h=0.5, lty=2, lwd=2, col="Orange")
## abline(v=35, lty=2, lwd=2, col="Green")
## legend("topright", legend=c("Targets", "Non-Targets", "50% Efficiency",
## 	"Experimental [FA]"), col=c("Blue", "Red", "Orange", "Green"),
## 	lwd=c(2, 2, 2, 2), lty=c(1, 3, 2, 2))


###################################################
### code chunk number 12: expr9 (eval = FALSE)
###################################################
## probes <- DesignProbes(tiles, identifier="Sphingopyxis",
## 	start=120, end=1450, numProbeSets=100)


###################################################
### code chunk number 13: expr10 (eval = FALSE)
###################################################
## head(probes)


###################################################
### code chunk number 14: expr11
###################################################
dna <- SearchDB(dbConn, nameBy="id", verbose=FALSE)
dbDisconnect(dbConn)

# move the target group to the top of the sequence set
w <- which(names(dna)=="Sphingopyxis")
dna <- c(dna[w], dna[-w])

BrowseSequences(dna, color=c(204, 253, 1019, 1045), highlight=1)


###################################################
### code chunk number 15: sessinfo
###################################################
toLatex(sessionInfo(), locale=FALSE)


