/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Normalize
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected double m_Norm = 1.0;
    protected double m_LNorm = 2.0;

    public String globalInfo() {
        return "An instance filter that normalize instances considering only numeric attributes and ignoring class index.";
    }

    public String LNormTipText() {
        return "The LNorm to use.";
    }

    public String normTipText() {
        return "The norm of the instances after normalization.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSpecify the norm that each instance must have (default 1.0)", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tSpecify L-norm to use (default 2.0)", "L", 1, "-L <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNorm(Double.parseDouble(string));
        } else {
            this.setNorm(1.0);
        }
        String string2 = Utils.getOption('L', stringArray);
        if (string2.length() != 0) {
            this.setLNorm(Double.parseDouble(string2));
        } else {
            this.setLNorm(2.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNorm();
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.getLNorm();
        return stringArray;
    }

    public double getNorm() {
        return this.m_Norm;
    }

    public void setNorm(double d) {
        this.m_Norm = d;
    }

    public double getLNorm() {
        return this.m_LNorm;
    }

    public void setLNorm(double d) {
        this.m_LNorm = d;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        int n;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance instance2 = (Instance)instance.copy();
        double d = 0.0;
        for (n = 0; n < this.getInputFormat().numAttributes(); ++n) {
            if (this.getInputFormat().classIndex() == n || !this.getInputFormat().attribute(n).isNumeric()) continue;
            d += Math.pow(Math.abs(instance2.value(n)), this.getLNorm());
        }
        d = Math.pow(d, 1.0 / this.getLNorm());
        for (n = 0; n < this.getInputFormat().numAttributes(); ++n) {
            if (this.getInputFormat().classIndex() == n || !this.getInputFormat().attribute(n).isNumeric()) continue;
            instance2.setValue(n, instance2.value(n) / d * this.getNorm());
        }
        this.push(instance2);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Normalize(), stringArray);
            } else {
                Filter.filterFile(new Normalize(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

