### R code from vignette source 'BiGGR.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: e (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("BiGGR")


###################################################
### code chunk number 2: f
###################################################
library("BiGGR")


###################################################
### code chunk number 3: g (eval = FALSE)
###################################################
## library(help="BiGGR")


###################################################
### code chunk number 4: h
###################################################
##load reaction identifiers from package examples
file.name <- system.file("extdata", 
                         "Glycolysis_TCA_recon1_reactionIDs.txt", 
                         package="BiGGR")
reaction.ids <- scan(file.name, what=" ")

##load database
data("H.sapiens_Recon_1")

##build SBML model
sbml.model <- buildSBMLFromReactionIDs(reaction.ids, H.sapiens_Recon_1)


###################################################
### code chunk number 5: i
###################################################
##following term is to be maximized
maximize <- "R_ATPS4m - R_NDPK1m - R_HEX1 - R_PFK - R_PGK + R_PYK"

##specify the external metabolites of the system
externals <- c("M_glc_DASH_D_e", "M_lac_DASH_L_e",
               "M_ala_DASH_L_e", "M_gln_DASH_L_c", "M_h2o_e",
               "M_co2_e", "M_o2_e", "M_h_e", "M_pi_c",
               "M_o2s_m", "M_nh4_m", "M_adp_c",
               "M_atp_c", "M_nadp_c", "M_nadph_c", "M_h_c")
##specify the values of following fluxes: 
##R_GLCt1r=0.4, R_O2t=2.4, R_L_LACt2r=R_GLNtm=0

equation.vars <- c("R_GLCt1r", "R_O2t", "R_L_LACt2r", "R_GLNtm")
equation.values <- c(0.4, 2.4, 0.0, 0.0)
eqns <- list(equation.vars, equation.values)

##create LIM file which is written to the
##hard disk in the system's temporary directory
limfile.path <- tempfile()
createLIMFromSBML(sbml.model, maximize, equations=eqns,
                  externals=externals, file.name=limfile.path)


###################################################
### code chunk number 6: j
###################################################
rates <- getRates(limfile.path)


###################################################
### code chunk number 7: k
###################################################
relevant.species <- c("M_glc_DASH_D_c", "M_g6p_c", "M_f6p_c", 
                      "M_fdp_c", "M_dhap_c", "M_g3p_c", 
                      "M_13dpg_c", "M_3pg_c", "M_2pg_c", 
                      "M_pep_c", "M_pyr_c")

hd <- sbml2hyperdraw(sbml.model, rates=rates, 
                     relevant.species=relevant.species, 
                     layoutType="dot", plt.margins=c(20, 0, 20, 0))


###################################################
### code chunk number 8: l (eval = FALSE)
###################################################
## plot(hd)


###################################################
### code chunk number 9: figure1
###################################################
plot(hd)


###################################################
### code chunk number 10: m (eval = FALSE)
###################################################
## relevant.species <- c("M_cit_m", "M_icit_m" , "M_akg_m",
##                       "M_succoa_m", "M_succ_m", "M_fum_m", 
##                       "M_mal_DASH_L_m", "M_oaa_m") 
## relevant.reactions <- c("R_CSm", "R_ACONTm", "R_ICDHxm",
##                         "R_AKGDm", "R_SUCOAS1m", "R_SUCD1m", 
##                         "R_FUMm", "R_MDHm", "R_ICDHyrm", "R_ME1m", 
##                         "R_ME2m", "R_ASPTAm","R_AKGMALtm", "R_GLUDym", 
##                         "R_ABTArm", "R_SSALxm","R_CITtam")
## hd <- sbml2hyperdraw(sbml.model, rates=rates,
##                      relevant.reactions=relevant.reactions,
##                      relevant.species=relevant.species,
##                      layoutType="circo", plt.margins=c(100, 235, 100, 230))
## dev.new() ##Open a new plotting device
## plot(hd)


###################################################
### code chunk number 11: figure2
###################################################
relevant.species <- c("M_cit_m", "M_icit_m" , "M_akg_m",
                      "M_succoa_m", "M_succ_m", "M_fum_m", 
                      "M_mal_DASH_L_m", "M_oaa_m") 
relevant.reactions <- c("R_CSm", "R_ACONTm", "R_ICDHxm",
                        "R_AKGDm", "R_SUCOAS1m", "R_SUCD1m", 
                        "R_FUMm", "R_MDHm", "R_ICDHyrm", "R_ME1m", 
                        "R_ME2m", "R_ASPTAm","R_AKGMALtm", "R_GLUDym", 
                        "R_ABTArm", "R_SSALxm","R_CITtam")
hd <- sbml2hyperdraw(sbml.model, rates=rates,
                     relevant.reactions=relevant.reactions,
                     relevant.species=relevant.species,
                     layoutType="circo", plt.margins=c(150, 235, 150, 230))
plot(hd)


