### R code from vignette source 'src/sec12_scatterplots.Rnw'

###################################################
### code chunk number 1: heatmap1
###################################################
library("HD2013SGI")

data("datamatrix",package="HD2013SGI")

dir.create(file.path("result","Figures"),showWarnings=FALSE,recursive=TRUE)


###################################################
### code chunk number 2: distributionOfInteractions1
###################################################
D = datamatrix$D
D = aperm(D, c(1,2,3,4,6,5))
dim(D) = c(prod(dim(D)[1:5]),dim(D)[6])


###################################################
### code chunk number 3: distributionOfInteractions2
###################################################
set.seed(712608)
S = sample(dim(D)[1],1000)


###################################################
### code chunk number 4: distributionOfInteractions3
###################################################
pdf(file.path("result","Figures","heatpairsFeatures.pdf"),width=10,height=10)


###################################################
### code chunk number 5: distributionOfInteractions4
###################################################
heatpairs(D[S,], cor.cex = 1.8,pch=20,main="")


###################################################
### code chunk number 6: distributionOfInteractions5
###################################################
dev.off()

png(file.path("result","Figures","heatpairsFeatures.png"),width=800,height=800)
heatpairs(D[S,], cor.cex = 1.8,pch=20,main="")
dev.off()


