### R code from vignette source 'src/sec11_distributionOfInteractions.Rnw'

###################################################
### code chunk number 1: distributionOfInteractions1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")
data("mainEffects",package="HD2013SGI")
data("nrOfInteractionsPerTarget",package="HD2013SGI")

dir.create(file.path("result","Figures"),showWarnings=FALSE,recursive=TRUE)


###################################################
### code chunk number 2: distributionOfInteractions2
###################################################
PI = Interactions$piscore
PI = (PI[,,,,,1]+PI[,,,,,2]) / 2


###################################################
### code chunk number 3: distributionOfInteractions3
###################################################
npos = rep(NA_integer_, dim(PI)[5])
nneg = rep(NA_integer_, dim(PI)[5])
for (i in seq_len(dim(PI)[5])) {
  I = which(Interactions$padj[,,,,i] <= 0.01)
  pi = (PI[,,,,i])[I]
  npos[i] = sum(pi >= 0)
  nneg[i] = sum(pi < 0)
}


###################################################
### code chunk number 4: distributionOfInteractions4
###################################################
I = order(-(npos+nneg))
npos = npos[I]
nneg = nneg[I]


###################################################
### code chunk number 5: distributionOfInteractions5
###################################################
pdf(file.path("result","Figures","distributionOfInteractions.pdf"),
    width=5,height=5)


###################################################
### code chunk number 6: distributionOfInteractions6
###################################################
barplot(rbind(npos,nneg),beside=TRUE,
        col=HD2013SGI:::Colors[c(3,1)],
        xlab="phenotypic features",ylab="number of interactions")
legend("topright",legend=c("pos. interactions", "neg. interactions"),
       fill=HD2013SGI:::Colors[c(3,1)])


###################################################
### code chunk number 7: distributionOfInteractions7
###################################################
dev.off()


