### R code from vignette source 'src/sec07_exampleInteractions.Rnw'

###################################################
### code chunk number 1: exampleSingleKnockDownEffects1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")
data("mainEffects",package="HD2013SGI")

dir.create(file.path("result","Figures"),
           recursive=TRUE,showWarnings=FALSE)


###################################################
### code chunk number 2: exampleSingleKnockDownEffects2
###################################################
features = c("count", "nuc.0.s.area","nuc.0.m.eccentricity",
             "cell.Bact.m.eccentricity","cell.act.m.majoraxis")
ylim = c(-2.947124, 7.329518)


###################################################
### code chunk number 3: exampleSingleKnockDownEffects3
###################################################
pdf(file=file.path("result","Figures","singleKnockDown-SETD8.pdf"),
    width=2.5,height=5)


###################################################
### code chunk number 4: exampleSingleKnockDownEffects4
###################################################
HD2013SGI:::plotExampleSingleGeneEffects(gene="SETD8",features,mainEffects,ylim)


###################################################
### code chunk number 5: exampleSingleKnockDownEffects5
###################################################
dev.off()
pdf(file=file.path("result","Figures","singleKnockDown-TCF20.pdf"),
    width=2.5,height=5)


###################################################
### code chunk number 6: exampleSingleKnockDownEffects6
###################################################
HD2013SGI:::plotExampleSingleGeneEffects(gene="TCF20",features,mainEffects,ylim)


###################################################
### code chunk number 7: exampleSingleKnockDownEffects7
###################################################
dev.off()


###################################################
### code chunk number 8: exampleInteractions1
###################################################
pdf(file=file.path("result","Figures","interaction-PHF16-SETD8.pdf"),
    height=4,width=3)


###################################################
### code chunk number 9: exampleInteractions1
###################################################
HD2013SGI:::plotExampleInteractions(feature="cell.act.m.majoraxis",
                                    target="PHF16",query="SETD8",
                                    Interactions, mainEffects)


###################################################
### code chunk number 10: exampleInteractions2
###################################################
dev.off()
pdf(file=file.path("result","Figures","interaction-SIN3A-RUVBL1.pdf"),
    height=4,width=3)


###################################################
### code chunk number 11: exampleInteractions3
###################################################
HD2013SGI:::plotExampleInteractions(feature="nuc.0.m.eccentricity",
                                    target="SIN3A",query="RUVBL1",
                                    Interactions, mainEffects)


###################################################
### code chunk number 12: exampleInteractions4
###################################################
dev.off()


###################################################
### code chunk number 13: overlapOfInteractions1
###################################################
features = c("nuc.0.s.area","nuc.0.m.majoraxis",
             "cell.Bact.m.eccentricity","cell.act.m.majoraxis")
SIG = Interactions$padj[,,,,features] <= 0.01
SIG[is.na(SIG)] = FALSE


###################################################
### code chunk number 14: overlapOfInteractions2
###################################################
dim(SIG) = c(prod(dim(SIG)[1:4]), dim(SIG)[5])
row.names(SIG) = sprintf("A%d",seq_len(nrow(SIG)))
colnames(SIG) = HD2013SGI:::humanReadableNames[features]


###################################################
### code chunk number 15: overlapOfInteractions3
###################################################
I = which(apply(SIG, 1, any))
Overlap = table(as.data.frame(SIG[I,]))
Overlap
save(Overlap, file=file.path("result","Figures","Overlap.rda"))


###################################################
### code chunk number 16: overlapOfInteractions4 (eval = FALSE)
###################################################
## L = apply(SIG, 2, function(x) names(which(x)))
## for (i in seq_along(L)) {
##   writeLines(L[[i]],
##     file.path("result", "Figures", sprintf("interactionlist%d.txt",i)))
## }


###################################################
### code chunk number 17: overlapOfInteractions5
###################################################
pdf(file.path("result","Figures","Mosaicplot.pdf"))


###################################################
### code chunk number 18: overlapOfInteractions6
###################################################
mosaic(Overlap, shade = TRUE)


###################################################
### code chunk number 19: overlapOfInteractions7
###################################################
dev.off()


