/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchySearch {
    public static <E> HierarchyNode<E> findPosition(Relation<E> relation, E e, HierarchyNode<E> hierarchyNode, HierarchyNode<E> hierarchyNode2) {
        Set<HierarchyNode<E>> set;
        Set<HierarchyNode<E>> set2 = HierarchySearch.findParents(relation, e, hierarchyNode);
        if (((Object)set2).equals(set = HierarchySearch.findChildren(relation, e, hierarchyNode2, set2))) {
            assert (set2.size() == 1 && set.size() == 1);
            return set2.iterator().next();
        }
        HashSet<E> hashSet = new HashSet<E>();
        hashSet.add(e);
        return new HierarchyNode<E>(e, hashSet, set2, set);
    }

    protected static <E> Set<HierarchyNode<E>> findParents(final Relation<E> relation, final E e, HierarchyNode<E> hierarchyNode) {
        return HierarchySearch.search(new SearchPredicate<HierarchyNode<E>>(){

            @Override
            public Set<HierarchyNode<E>> getSuccessorElements(HierarchyNode<E> hierarchyNode) {
                return hierarchyNode.m_childNodes;
            }

            @Override
            public Set<HierarchyNode<E>> getPredecessorElements(HierarchyNode<E> hierarchyNode) {
                return hierarchyNode.m_parentNodes;
            }

            @Override
            public boolean trueOf(HierarchyNode<E> hierarchyNode) {
                return relation.doesSubsume(hierarchyNode.getRepresentative(), e);
            }
        }, Collections.singleton(hierarchyNode), null);
    }

    protected static <E> Set<HierarchyNode<E>> findChildren(final Relation<E> relation, final E e, HierarchyNode<E> hierarchyNode, Set<HierarchyNode<E>> set) {
        HashSet<HierarchyNode<HierarchyNode<E>>> hashSet;
        HashSet<HierarchyNode> hashSet2;
        if (set.size() == 1 && relation.doesSubsume(e, set.iterator().next().getRepresentative())) {
            return set;
        }
        Iterator<HierarchyNode<E>> iterator = set.iterator();
        HashSet<HierarchyNode<E>> hashSet3 = new HashSet<HierarchyNode<E>>(iterator.next().getDescendantNodes());
        while (iterator.hasNext()) {
            HierarchyNode hierarchyNode2;
            hashSet2 = new HashSet<HierarchyNode>();
            hashSet = new HashSet();
            LinkedList object = new LinkedList();
            object.add(iterator.next());
            while (!object.isEmpty()) {
                hierarchyNode2 = (HierarchyNode)object.remove();
                for (HierarchyNode hierarchyNode3 : hierarchyNode2.m_childNodes) {
                    if (hashSet3.contains(hierarchyNode3)) {
                        hashSet2.add(hierarchyNode3);
                        continue;
                    }
                    if (!hashSet.add(hierarchyNode3)) continue;
                    object.add(hierarchyNode3);
                }
            }
            object.addAll(hashSet2);
            while (!object.isEmpty()) {
                hierarchyNode2 = (HierarchyNode)object.remove();
                for (HierarchyNode hierarchyNode3 : hierarchyNode2.m_childNodes) {
                    if (!hashSet2.add(hierarchyNode3)) continue;
                    object.add(hierarchyNode3);
                }
            }
            hashSet3 = hashSet2;
        }
        hashSet2 = new HashSet();
        for (HierarchyNode hierarchyNode4 : hashSet3) {
            if (!hierarchyNode4.m_childNodes.contains(hierarchyNode) || !relation.doesSubsume(e, hierarchyNode4.getRepresentative())) continue;
            hashSet2.add(hierarchyNode4);
        }
        if (hashSet2.isEmpty()) {
            hashSet = new HashSet<HierarchyNode<HierarchyNode<E>>>();
            hashSet.add(hierarchyNode);
            return hashSet;
        }
        return HierarchySearch.search(new SearchPredicate<HierarchyNode<E>>(){

            @Override
            public Set<HierarchyNode<E>> getSuccessorElements(HierarchyNode<E> hierarchyNode) {
                return hierarchyNode.m_parentNodes;
            }

            @Override
            public Set<HierarchyNode<E>> getPredecessorElements(HierarchyNode<E> hierarchyNode) {
                return hierarchyNode.m_childNodes;
            }

            @Override
            public boolean trueOf(HierarchyNode<E> hierarchyNode) {
                return relation.doesSubsume(e, hierarchyNode.getRepresentative());
            }
        }, hashSet2, hashSet3);
    }

    public static <U> Set<U> search(SearchPredicate<U> searchPredicate, Collection<U> collection, Set<U> set) {
        SearchCache<U> searchCache = new SearchCache<U>(searchPredicate, set);
        HashSet hashSet = new HashSet();
        HashSet<U> hashSet2 = new HashSet<U>(collection);
        LinkedList<U> linkedList = new LinkedList<U>(collection);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.remove();
            boolean bl = false;
            Set<U> set2 = searchPredicate.getSuccessorElements(e);
            for (U u : set2) {
                if (!searchCache.trueOf(u)) continue;
                bl = true;
                if (!hashSet2.add(u)) continue;
                linkedList.add(u);
            }
            if (bl) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SearchCache<U> {
        protected final SearchPredicate<U> m_searchPredicate;
        protected final Set<U> m_possibilities;
        protected final Set<U> m_positives;
        protected final Set<U> m_negatives;

        public SearchCache(SearchPredicate<U> searchPredicate, Set<U> set) {
            this.m_searchPredicate = searchPredicate;
            this.m_possibilities = set;
            this.m_positives = new HashSet<U>();
            this.m_negatives = new HashSet<U>();
        }

        public boolean trueOf(U u) {
            if (this.m_positives.contains(u)) {
                return true;
            }
            if (this.m_negatives.contains(u) || this.m_possibilities != null && !this.m_possibilities.contains(u)) {
                return false;
            }
            for (U u2 : this.m_searchPredicate.getPredecessorElements(u)) {
                if (this.trueOf(u2)) continue;
                this.m_negatives.add(u);
                return false;
            }
            if (this.m_searchPredicate.trueOf(u)) {
                this.m_positives.add(u);
                return true;
            }
            this.m_negatives.add(u);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SearchPredicate<U> {
        public Set<U> getSuccessorElements(U var1);

        public Set<U> getPredecessorElements(U var1);

        public boolean trueOf(U var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Relation<U> {
        public boolean doesSubsume(U var1, U var2);
    }
}

