### R code from vignette source 'geNetClassifier-vignette.Rnw'

###################################################
### code chunk number 1: geNetClassifier-vignette.Rnw:87-89 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("geNetClassifier")


###################################################
### code chunk number 2: geNetClassifier-vignette.Rnw:95-96 (eval = FALSE)
###################################################
## biocLite("leukemiasEset")


###################################################
### code chunk number 3: geNetClassifier-vignette.Rnw:102-105
###################################################
library(leukemiasEset)
data(leukemiasEset)
leukemiasEset


###################################################
### code chunk number 4: geNetClassifier-vignette.Rnw:107-108
###################################################
summary(leukemiasEset$LeukemiaType) 


###################################################
### code chunk number 5: geNetClassifier-vignette.Rnw:110-111 (eval = FALSE)
###################################################
## pData(leukemiasEset)


###################################################
### code chunk number 6: geNetClassifier-vignette.Rnw:114-115 (eval = FALSE)
###################################################
## ?leukemiasEset


###################################################
### code chunk number 7: geNetClassifier-vignette.Rnw:121-124 (eval = FALSE)
###################################################
## load("genes-human-annotation.R")
## geneSymbols <- genes.human.Annotation[,"gene_symbol",drop=F]
## head(geneSymbols)


###################################################
### code chunk number 8: geNetClassifier-vignette.Rnw:128-133 (eval = FALSE)
###################################################
## leukEset_protCoding <- leukemiasEset[featureNames(leukemiasEset) 
##  %in% rownames(genes.human.Annotation[genes.human.Annotation$biotype 
##  %in% "protein_coding",]),]
## dim(leukemiasEset)
## dim(leukEset_protCoding)


###################################################
### code chunk number 9: geNetClassifier-vignette.Rnw:159-160
###################################################
library(geNetClassifier)


###################################################
### code chunk number 10: geNetClassifier-vignette.Rnw:163-167 (eval = FALSE)
###################################################
## # List available vignettes for package geNetClassifier: 
## vignette(package="geNetClassifier")
## # Open vignette named "geNetClassifier-vignette":
## vignette("geNetClassifier-vignette")


###################################################
### code chunk number 11: geNetClassifier-vignette.Rnw:170-171
###################################################
options(width=80)


###################################################
### code chunk number 12: geNetClassifier-vignette.Rnw:173-174
###################################################
objects("package:geNetClassifier")


###################################################
### code chunk number 13: geNetClassifier-vignette.Rnw:176-177 (eval = FALSE)
###################################################
## ?geNetClassifier


###################################################
### code chunk number 14: geNetClassifier-vignette.Rnw:180-182 (eval = FALSE)
###################################################
## library(leukemiasEset)
## data(leukemiasEset)


###################################################
### code chunk number 15: geNetClassifier-vignette.Rnw:185-186 (eval = FALSE)
###################################################
## load(file="...")


###################################################
### code chunk number 16: geNetClassifier-vignette.Rnw:191-193
###################################################
trainSamples <- c(1:10, 13:22, 25:34, 37:46, 49:58)
summary(leukemiasEset$LeukemiaType[trainSamples])


###################################################
### code chunk number 17: geNetClassifier-vignette.Rnw:227-229 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier") 


###################################################
### code chunk number 18: geNetClassifier-vignette.Rnw:232-235 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## estimateGError=TRUE)


###################################################
### code chunk number 19: geNetClassifier-vignette.Rnw:238-241 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## skipInteractions=TRUE, maxGenesTrain=20, geneLabels=geneSymbols)


###################################################
### code chunk number 20: geNetClassifier-vignette.Rnw:248-249 (eval = FALSE)
###################################################
## save(leukemiasClassifier, file="leukemiasClassifier.RData") 


###################################################
### code chunk number 21: geNetClassifier-vignette.Rnw:253-256 (eval = FALSE)
###################################################
## getwd()
## dir()
## load("leukemiasClassifier.RData")


###################################################
### code chunk number 22: geNetClassifier-vignette.Rnw:260-261
###################################################
data(leukemiasClassifier) 


###################################################
### code chunk number 23: geNetClassifier-vignette.Rnw:265-268 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(leukEset_protCoding[,trainSamples],
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier",
##  estimateGError=TRUE, geneLabels=geneSymbols)


###################################################
### code chunk number 24: geNetClassifier-vignette.Rnw:276-277
###################################################
class(leukemiasClassifier)


###################################################
### code chunk number 25: geNetClassifier-vignette.Rnw:281-282
###################################################
options(width=50)


###################################################
### code chunk number 26: geNetClassifier-vignette.Rnw:284-285
###################################################
names(leukemiasClassifier)


###################################################
### code chunk number 27: geNetClassifier-vignette.Rnw:287-288
###################################################
options(width=80)


###################################################
### code chunk number 28: geNetClassifier-vignette.Rnw:293-294
###################################################
leukemiasClassifier@call


###################################################
### code chunk number 29: geNetClassifier-vignette.Rnw:298-299
###################################################
leukemiasClassifier


###################################################
### code chunk number 30: geNetClassifier-vignette.Rnw:313-314
###################################################
leukemiasClassifier@genesRanking


###################################################
### code chunk number 31: geNetClassifier-vignette.Rnw:318-319
###################################################
numGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 32: geNetClassifier-vignette.Rnw:323-324
###################################################
miniRanking <- getTopRanking(leukemiasClassifier@genesRanking, 6)


###################################################
### code chunk number 33: geNetClassifier-vignette.Rnw:328-329
###################################################
getRanking(miniRanking)


###################################################
### code chunk number 34: geNetClassifier-vignette.Rnw:332-333
###################################################
getRanking(miniRanking, showGeneID=TRUE)$geneID


###################################################
### code chunk number 35: geNetClassifier-vignette.Rnw:337-338
###################################################
genesDetails(miniRanking)$AML


###################################################
### code chunk number 36: geNetClassifier-vignette.Rnw:342-343 (eval = FALSE)
###################################################
## options(width=200)


###################################################
### code chunk number 37: geNetClassifier-vignette.Rnw:377-378
###################################################
numSignificantGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 38: geNetClassifier-vignette.Rnw:382-383 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 39: geNetClassifier-vignette.Rnw:387-389 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, 
## numGenesPlot=3000, lpThreshold=0.80)


###################################################
### code chunk number 40: geNetClassifier-vignette.Rnw:401-402
###################################################
leukemiasClassifier@classifier


###################################################
### code chunk number 41: geNetClassifier-vignette.Rnw:406-407
###################################################
leukemiasClassifier@classificationGenes


###################################################
### code chunk number 42: geNetClassifier-vignette.Rnw:409-411
###################################################
numGenes(leukemiasClassifier@classificationGenes)
genesDetails(leukemiasClassifier@classificationGenes)$ALL


###################################################
### code chunk number 43: geNetClassifier-vignette.Rnw:470-471
###################################################
leukemiasClassifier@generalizationError


###################################################
### code chunk number 44: geNetClassifier-vignette.Rnw:474-475 (eval = FALSE)
###################################################
## overview(leukemiasClassifier@generalizationError)


###################################################
### code chunk number 45: geNetClassifier-vignette.Rnw:481-482
###################################################
leukemiasClassifier@generalizationError@confMatrix


###################################################
### code chunk number 46: geNetClassifier-vignette.Rnw:486-487
###################################################
leukemiasClassifier@generalizationError@probMatrix


###################################################
### code chunk number 47: geNetClassifier-vignette.Rnw:496-497
###################################################
leukemiasClassifier@generalizationError@classificationGenes.stats$CLL


###################################################
### code chunk number 48: geNetClassifier-vignette.Rnw:502-503
###################################################
leukemiasClassifier@generalizationError@classificationGenes.num


###################################################
### code chunk number 49: geNetClassifier-vignette.Rnw:517-519
###################################################
leukemiasClassifier@genesNetwork
overview(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 50: geNetClassifier-vignette.Rnw:524-526
###################################################
getNumEdges(leukemiasClassifier@genesNetwork$AML)
getNumNodes(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 51: geNetClassifier-vignette.Rnw:528-530
###################################################
getEdges(leukemiasClassifier@genesNetwork$AML)[1:5,]
getNodes(leukemiasClassifier@genesNetwork$AML)[1:12]


###################################################
### code chunk number 52: geNetClassifier-vignette.Rnw:534-535 (eval = FALSE)
###################################################
## network2txt(leukemiasClassifier@genesNetwork, filePrefix="leukemiasNetwork")


###################################################
### code chunk number 53: geNetClassifier-vignette.Rnw:538-541 (eval = FALSE)
###################################################
## geneNtwsInfo <- lapply(leukemiasClassifier@genesNetwork, 
## function(x) write.table(getEdges(x), 
## file=paste("leukemiaNtw_",getEdges(x)[1,"class1"],".txt",sep="")))


###################################################
### code chunk number 54: geNetClassifier-vignette.Rnw:554-556
###################################################
testSamples <- c(1:60)[-trainSamples]
testSamples


###################################################
### code chunk number 55: geNetClassifier-vignette.Rnw:560-562
###################################################
queryResult <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 56: geNetClassifier-vignette.Rnw:566-568
###################################################
queryResult$class
queryResult$probabilities


###################################################
### code chunk number 57: geNetClassifier-vignette.Rnw:572-574
###################################################
confusionMatrix <- table(leukemiasEset[,testSamples]$LeukemiaType, 
queryResult$class)


###################################################
### code chunk number 58: geNetClassifier-vignette.Rnw:578-579
###################################################
externalValidation.stats(confusionMatrix)


###################################################
### code chunk number 59: geNetClassifier-vignette.Rnw:583-585
###################################################
externalValidation.probMatrix(queryResult, 
leukemiasEset[,testSamples]$LeukemiaType, numDecimals=3)


###################################################
### code chunk number 60: geNetClassifier-vignette.Rnw:597-600
###################################################
queryResult_AssignAll <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples], minProbAssignCoeff=0, minDiffAssignCoeff=0)
which(queryResult_AssignAll$class=="NotAssigned")


###################################################
### code chunk number 61: geNetClassifier-vignette.Rnw:606-609
###################################################
queryResult_AssignLess <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples], minProbAssignCoeff=1.5, minDiffAssignCoeff=1)
queryResult_AssignLess$class


###################################################
### code chunk number 62: geNetClassifier-vignette.Rnw:612-614
###################################################
t(queryResult_AssignLess$probabilities[,
queryResult_AssignLess$class=="NotAssigned", drop=FALSE])


###################################################
### code chunk number 63: geNetClassifier-vignette.Rnw:618-620
###################################################
confusionMatrix2 <- table(leukemiasEset[,testSamples]$LeukemiaType, 
queryResult_AssignLess$class)


###################################################
### code chunk number 64: geNetClassifier-vignette.Rnw:622-623
###################################################
externalValidation.stats(confusionMatrix2)


###################################################
### code chunk number 65: geNetClassifier-vignette.Rnw:644-645
###################################################
testSamples <- c(1:60)[-trainSamples]


###################################################
### code chunk number 66: geNetClassifier-vignette.Rnw:649-651
###################################################
queryResult_AsUnkown <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 67: geNetClassifier-vignette.Rnw:655-656
###################################################
names(queryResult_AsUnkown)


###################################################
### code chunk number 68: geNetClassifier-vignette.Rnw:658-659
###################################################
queryResult_AsUnkown$class


###################################################
### code chunk number 69: geNetClassifier-vignette.Rnw:663-665
###################################################
t(queryResult_AsUnkown$probabilities[ ,
queryResult$class=="NotAssigned"])


###################################################
### code chunk number 70: geNetClassifier-vignette.Rnw:669-670
###################################################
querySummary(queryResult_AsUnkown, numDecimals=3)


###################################################
### code chunk number 71: geNetClassifier-vignette.Rnw:683-684 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 72: geNetClassifier-vignette.Rnw:689-691 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, numGenesPlot=3000, 
## plotTitle="5 classes: ALL, AML, CLL, CML, NoL", lpThreshold=0.80)


###################################################
### code chunk number 73: geNetClassifier-vignette.Rnw:701-703 (eval = FALSE)
###################################################
## ranking <- calculateGenesRanking(leukemiasEset[,trainSamples], 
## "LeukemiaType")


###################################################
### code chunk number 74: geNetClassifier-vignette.Rnw:712-715 (eval = FALSE)
###################################################
## myGenes <- c("ENSG00000169575", "ENSG00000078399", 
## "ENSG00000176890", "ENSG00000121742")
## plotExpressionProfiles(leukemiasEset, myGenes, sampleLabels="LeukemiaType")


###################################################
### code chunk number 75: geNetClassifier-vignette.Rnw:725-727 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset[,trainSamples], leukemiasClassifier,
## sampleLabels="LeukemiaType", fileName="leukExprs_trainSamples.pdf")


###################################################
### code chunk number 76: geNetClassifier-vignette.Rnw:731-735 (eval = FALSE)
###################################################
## classGenes <- getRanking(leukemiasClassifier@classificationGenes, 
## showGeneID=TRUE)$geneID[,"AML"]
## plotExpressionProfiles(leukemiasEset, genes=classGenes, 
## sampleLabels="LeukemiaType", fileName="AML.pdf", geneLabels=geneSymbols)


###################################################
### code chunk number 77: geNetClassifier-vignette.Rnw:748-750
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 78: geNetClassifier-vignette.Rnw:754-756
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 79: geNetClassifier-vignette.Rnw:764-767 (eval = FALSE)
###################################################
## discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
## classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
## showGeneID=T)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 80: geNetClassifier-vignette.Rnw:771-774
###################################################
discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
showGeneID=T)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 81: geNetClassifier-vignette.Rnw:789-791
###################################################
clGenesSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 82: geNetClassifier-vignette.Rnw:798-799 (eval = FALSE)
###################################################
## clGenesInfo <- genesDetails(leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 83: geNetClassifier-vignette.Rnw:806-808 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo, 
## plotAllNodesNetwork=FALSE, plotOnlyConnectedNodesNetwork=TRUE)


###################################################
### code chunk number 84: geNetClassifier-vignette.Rnw:812-813 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo)


###################################################
### code chunk number 85: geNetClassifier-vignette.Rnw:824-830 (eval = FALSE)
###################################################
## top30g <- getRanking(leukemiasClassifier@genesRanking, 
## showGeneID=TRUE)$geneID[1:30,]
## top30gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, top30g)
## top30gInfo <- lapply(genesDetails(leukemiasClassifier@genesRanking), 
## function(x) x[1:30,])
## plotNetwork(genesNetwork=top30gSubNet$AML, genesInfo=top30gInfo$AML)


###################################################
### code chunk number 86: geNetClassifier-vignette.Rnw:843-853 (eval = FALSE)
###################################################
## top100gRanking <- getTopRanking(leukemiasClassifier@genesRanking, 
## numGenes=100)
## top100gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
## getRanking(top100gRanking, showGeneID=TRUE)$geneID)
## plotNetwork(genesNetwork=top100gSubNet, 
## classificationGenes=leukemiasClassifier@classificationGenes, 
## genesRanking=top100gRanking, plotAllNodesNetwork=TRUE, 
## plotOnlyConnectedNodesNetwork=TRUE, labelSize=0.4, 
## returniGraphs=FALSE, plotType="pdf", 
## fileName="leukemiasNetwork")


