### R code from vignette source 'flowQB_Sweave_.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: tab1
###################################################
rm(list=ls(all=TRUE))
library(flowQB)
File= system.file("extdata","NIH.fcs",package="flowQB")


###################################################
### code chunk number 2: tab1
###################################################
P <- 96	
MFI2D <- ReadDD(File,1,2,P,5,3)


###################################################
### code chunk number 3: tab1
###################################################
MFIMeansSDs=KmeansMeanSD(MFI2D,8,300,300,1)


###################################################
### code chunk number 4: tab1
###################################################
MFIMeansSDs[,1]


###################################################
### code chunk number 5: tab1
###################################################
MFIMeansSDs[,2]


###################################################
### code chunk number 6: tab1
###################################################
p <- 357217.00/7102
MFI2MSEF=MFI2MESF(MFIMeansSDs,p,0)


###################################################
### code chunk number 7: tab1
###################################################
MFI2MSEF[,1]


###################################################
### code chunk number 8: tab1
###################################################
MFI2MSEF[,2]


###################################################
### code chunk number 9: tab1
###################################################
QQB <- qrMESF(MFI2MSEF,3,6)
OV <- c(Q=as.double(QQB[1]), B=as.double(QQB[2]), Rsquared=as.double(round(QQB[3], 2)))
OV[1]
OV[2]
OV[3]


###################################################
### code chunk number 10: tab1
###################################################
IllCorrCV <- MFIMeansSDs[8,2]/MFIMeansSDs[8,1]	
MFI2MSEF <- MFI2MESF(MFIMeansSDs,p,IllCorrCV)
LQB <- lrMESF(MFI2MSEF,3,5)
OV <- c(Q=as.double(LQB[1]), B=as.double(LQB[2]), Rsquared=as.double(round(LQB[3], 2)))
OV[1]
OV[2]
OV[3]



###################################################
### code chunk number 11: tab1
###################################################
Coefs <- DiscriminantExamination(as.double(QQB[1]),as.double(QQB[2]),as.double(QQB[4]))

Coefs[1]
Coefs[2]
Coefs[3]
Coefs[4]

Delta <- Coefs[4]
if(Delta >= 0) 
{
cat(paste("The sign of the discriminant is positive with the value", round(Delta,2), ". "))
cat("The larger the variation product of (sigmaE2) and (sigmaS2), ")
cat("the lower the upper bound on the detection efficiency Q. ")
} 
if(Delta < 0) 
{
cat(paste("The sign of the discriminant is negative with the value", round(Delta,2), ". "))
cat("The lower the variation product of (sigmaE2) and (sigmaS2), ")
cat("the greater the upper bound on the detection efficiency Q. ")
}



