### R code from vignette source 'cn.mops.Rnw'

###################################################
### code chunk number 1: cn.mops.Rnw:40-44
###################################################
options(width=75)
set.seed(0)
library(cn.mops)
cn.mopsVersion <- packageDescription("cn.mops")$Version


###################################################
### code chunk number 2: cn.mops.Rnw:137-138
###################################################
library(cn.mops)


###################################################
### code chunk number 3: cn.mops.Rnw:147-149 (eval = FALSE)
###################################################
## BAMFiles <- list.files(pattern=".bam$")
## bamDataRanges <- getReadCountsFromBAM(BAMFiles)


###################################################
### code chunk number 4: cn.mops.Rnw:153-154 (eval = FALSE)
###################################################
## res <- cn.mops(bamDataRanges)


###################################################
### code chunk number 5: cn.mops.Rnw:159-160 (eval = FALSE)
###################################################
## plot(res,which=1)


###################################################
### code chunk number 6: cn.mops.Rnw:164-169
###################################################
data(cn.mops)
resCNMOPS <- cn.mops(XRanges)
pdf("003.pdf")
plot(resCNMOPS,which=7,toFile=TRUE)
dev.off()


###################################################
### code chunk number 7: cn.mops.Rnw:228-232
###################################################
BAMFiles <- list.files(system.file("extdata", package="cn.mops"),pattern=".bam$",
		full.names=TRUE)
bamDataRanges <- getReadCountsFromBAM(BAMFiles,
		sampleNames=paste("Sample",1:3),mode="unpaired")


###################################################
### code chunk number 8: cn.mops.Rnw:237-238
###################################################
(bamDataRanges)


###################################################
### code chunk number 9: cn.mops.Rnw:257-259
###################################################
data(cn.mops)
ls()


###################################################
### code chunk number 10: cn.mops.Rnw:264-265
###################################################
head(XRanges[,1:3])


###################################################
### code chunk number 11: cn.mops.Rnw:268-269 (eval = FALSE)
###################################################
## resCNMOPS <- cn.mops(XRanges)


###################################################
### code chunk number 12: cn.mops.Rnw:273-274
###################################################
resCNMOPS <- calcIntegerCopyNumbers(resCNMOPS)


###################################################
### code chunk number 13: cn.mops.Rnw:280-281
###################################################
head(X[,1:3])


###################################################
### code chunk number 14: cn.mops.Rnw:284-285 (eval = FALSE)
###################################################
## resCNMOPSX <- cn.mops(X)


###################################################
### code chunk number 15: cn.mops.Rnw:289-290 (eval = FALSE)
###################################################
## resCNMOPSX <- calcIntegerCopyNumbers(resCNMOPSX)


###################################################
### code chunk number 16: cn.mops.Rnw:296-297 (eval = FALSE)
###################################################
## all(individualCall(resCNMOPSX)==individualCall(resCNMOPS))


###################################################
### code chunk number 17: cn.mops.Rnw:303-304 (eval = FALSE)
###################################################
## (resCNMOPS)


###################################################
### code chunk number 18: cn.mops.Rnw:308-309
###################################################
cnvs(resCNMOPS)[1:5]


###################################################
### code chunk number 19: cn.mops.Rnw:314-315
###################################################
cnvr(resCNMOPS)[1,1:5]


###################################################
### code chunk number 20: cn.mops.Rnw:321-322
###################################################
(CNVRanges[15,1:5])


###################################################
### code chunk number 21: cn.mops.Rnw:328-330
###################################################
ranges(cnvr(resCNMOPS))[1:2]
ranges(cnvr(resCNMOPS)) %in% ranges(CNVRanges)


###################################################
### code chunk number 22: cn.mops.Rnw:336-337 (eval = FALSE)
###################################################
## help(CNVDetectionResult)


###################################################
### code chunk number 23: cn.mops.Rnw:346-347 (eval = FALSE)
###################################################
## segplot(resCNMOPS,sampleIdx=13)


###################################################
### code chunk number 24: cn.mops.Rnw:350-353
###################################################
pdf("002.pdf")
segplot(resCNMOPS,sampleIdx=13,seqnames="chrA")
dev.off()


###################################################
### code chunk number 25: cn.mops.Rnw:372-373 (eval = FALSE)
###################################################
## plot(resCNMOPS,which=1)


###################################################
### code chunk number 26: cn.mops.Rnw:376-379
###################################################
pdf("001.pdf")
plot(resCNMOPS,which=1,toFile=TRUE)
dev.off()


###################################################
### code chunk number 27: cn.mops.Rnw:442-449 (eval = FALSE)
###################################################
## library(cn.mops)
## BAMFiles <- list.files(pattern=".bam$")
## segments <- read.table("targetRegions.bed",sep="\t",as.is=TRUE)
## gr <- GRanges(segments[,1],IRanges(segments[,2],segments[,3]))
## X <- getSegmentReadCountsFromBAM(BAMFiles,GR=gr,mode="unpaired")
## resCNMOPS <- exomecn.mops(X)
## resCNMOPS <- calcIntegerCopyNumbers(resCNMOPS)


###################################################
### code chunk number 28: cn.mops.Rnw:454-456
###################################################
resultExomeData <- exomecn.mops(exomeCounts)
resultExomeData  <- calcIntegerCopyNumbers(resultExomeData )


###################################################
### code chunk number 29: cn.mops.Rnw:459-460 (eval = FALSE)
###################################################
## plot(resultExomeData,which=4)


###################################################
### code chunk number 30: cn.mops.Rnw:463-466
###################################################
pdf("004.pdf")
plot(resultExomeData,which=4,toFile=TRUE)
dev.off()


###################################################
### code chunk number 31: cn.mops.Rnw:482-484 (eval = FALSE)
###################################################
## #the following removes the "chr" from reference sequence names
## seqlevels(gr) <- gsub("chr","",seqlevels(gr))


###################################################
### code chunk number 32: cn.mops.Rnw:490-492 (eval = FALSE)
###################################################
## gr <- GRanges(segments[,1],IRanges(segments[,2]-30,segments[,3]+30))
## gr <- reduce(gr)


###################################################
### code chunk number 33: cn.mops.Rnw:507-509
###################################################
XchrX <- normalizeChromosomes(X[1:500, ],ploidy=c(rep(1,10),rep(2,30)))
cnvr(calcIntegerCopyNumbers(cn.mops(XchrX,norm=FALSE)))


###################################################
### code chunk number 34: cn.mops.Rnw:523-525 (eval = FALSE)
###################################################
## resHaplo <- haplocn.mops(X)
## resHaplo <- calcIntegerCopyNumbers(resHaplo)


###################################################
### code chunk number 35: cn.mops.Rnw:534-537
###################################################
resRef <- referencecn.mops(cases=X[,1],controls=rowMeans(X))
resRef <- calcIntegerCopyNumbers(resRef)
(cnvs(resRef))


###################################################
### code chunk number 36: cn.mops.Rnw:548-549 (eval = FALSE)
###################################################
## toBibtex(citation("cn.mops"))


