### R code from vignette source 'cisPath.Rnw'

###################################################
### code chunk number 1: example1
###################################################
  library(cisPath)
  sprotFile <- system.file("extdata", "uniprot_sprot_human10.dat", 
                                            package="cisPath")
  mappingFile <- file.path(tempdir(), "mappingFile.txt")
  getMappingFile(sprotFile, output=mappingFile)


###################################################
### code chunk number 2: example2
###################################################
  STRINGPPI <- file.path(tempdir(), "STRINGPPI.txt")
  fileFromSTRING <- system.file("extdata", "protein.links.txt", 
                                             package="cisPath")
  formatSTRINGPPI(fileFromSTRING, mappingFile, "9606", output=STRINGPPI, 700)


###################################################
### code chunk number 3: example3
###################################################
  input <- system.file("extdata", "Homo_sapiens_PINA100.txt", package="cisPath")
  PINAPPI <- file.path(tempdir(), "PINAPPI.txt")
  formatPINAPPI(input, output=PINAPPI)


###################################################
### code chunk number 4: example4
###################################################
  input <- system.file("extdata", "9606.mitab.100.txt", package="cisPath")
  iRefIndex <- file.path(tempdir(), "iRefIndex.txt")
  formatiRefIndex(input, output=iRefIndex)


###################################################
### code chunk number 5: example5
###################################################
  output <- file.path(tempdir(), "allPPI.txt")
  combinePPI(c(PINAPPI, iRefIndex, STRINGPPI), output)


###################################################
### code chunk number 6: example6
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "networkView")
  networkView(infoFile, c("MAGI1","TP53BP2","TP53", "PTEN"), outputDir, 
                                   FALSE, c(1,1,1,0), displayMore=TRUE)


###################################################
### code chunk number 7: example7
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "networkView2")
  inputFile <- system.file("extdata", "networkView.txt", package="cisPath")
  rt <- read.table(inputFile, sep=",", comment.char="", header=TRUE)
  proteins <- as.vector(rt[,1])
  sizes <- as.vector(rt[,2])
  colors <- as.vector(rt[,3])
  networkView(infoFile, proteins, outputDir, FALSE, sizes, colors, FALSE)


###################################################
### code chunk number 8: example8
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example")
  results <- cisPath(infoFile, "TP53", outputDir, c("MAGI1", "GH1"), 
                                                       byStep=TRUE)
  results["MAGI1"]
  results["GH1"]


###################################################
### code chunk number 9: example9
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example")
  results <- cisPath(infoFile, "TP53", outputDir, 
                     targetProteins=c("Q96QZ7", "P01241"), swissProtID=TRUE)
  results["Q96QZ7"]
  results["P01241"]


###################################################
### code chunk number 10: example10
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example")
  results <- cisPath(infoFile, "TP53", outputDir)
  results["GH1"]
  results["P01241"]


###################################################
### code chunk number 11: example11
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example")
  name2protFile <- system.file("extdata", "name2prot.txt", package="cisPath")
  results <- cisPath(infoFile, "P04637", outputDir, name2IDFile=name2protFile)


###################################################
### code chunk number 12: example12
###################################################
  name2protFile <- system.file("extdata", "name2prot.txt", package="cisPath")
  addProteinNames(name2protFile, outputDir)


###################################################
### code chunk number 13: example13 (eval = FALSE)
###################################################
##   outputDir <- "/home/user/TP53"
##   # Create the output directory
##   dir.create(outputDir, showWarnings = FALSE, recursive = TRUE)
##   # infoFile: site where the PPI data file will be saved.
##   infoFile <- file.path(outputDir, "Homo_sapiens_PPI.txt")
##   # Download PPI data
##   url <- "http://www.isb.pku.edu.cn/cispath/data/Homo_sapiens_PPI.txt"
##   download.file(url, infoFile)
##   results <- cisPath(infoFile, "TP53", outputDir, byStep=TRUE) 
##   
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Homo_sapiens_PPI.txt"
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Caenorhabditis_elegans_PPI.txt"
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Drosophila_melanogaster_PPI.txt"
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Mus_musculus_PPI.txt"
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Rattus_norvegicus_PPI.txt"
##   url<-"http://www.isb.pku.edu.cn/cispath/data/Saccharomyces_cerevisiae_PPI.txt"


###################################################
### code chunk number 14: example14
###################################################
  outputDir <- file.path(tempdir(), "easyEditor")
  easyEditor(outputDir)


