### R code from vignette source 'SCAN.vignette.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: setup
###################################################
## do work in temporary directory
pwd <- setwd(tempdir())


###################################################
### code chunk number 2: SCAN.vignette.Rnw:71-73
###################################################
celFilePath = "Vignette_Example.CEL.gz"
download.file("http://www.ncbi.nlm.nih.gov/geo/download/?acc=GSM555237&format=file&file=GSM555237%2ECEL%2Egz", celFilePath, mode="wb")


###################################################
### code chunk number 3: SCAN.vignette.Rnw:80-82
###################################################
library(SCAN.UPC)
normalized = SCAN(celFilePath)


###################################################
### code chunk number 4: SCAN.vignette.Rnw:91-92
###################################################
normalized = SCAN(celFilePath, outFilePath="output_file.txt")


###################################################
### code chunk number 5: download-brainarray (eval = FALSE)
###################################################
## download.file("http://brainarray.mbni.med.umich.edu/Brainarray/Database/CustomCDF/15.0.0/entrezg.download/hgu95ahsentrezgprobe_15.0.0.tar.gz", "hgu95ahsentrezgprobe_15.0.0.tar.gz", mode="wb")
## install.packages("hgu95ahsentrezgprobe_15.0.0.tar.gz", repos=NULL, type="source")
## library(hgu95ahsentrezgprobe)


###################################################
### code chunk number 6: scan-brainarray (eval = FALSE)
###################################################
## normalized = SCAN(celFilePath, probeSummaryPackage=hgu95ahsentrezgprobe)


###################################################
### code chunk number 7: SCAN.vignette.Rnw:116-117
###################################################
unlink(c(celFilePath, "output_file.txt", "hgu95ahsentrezgprobe_15.0.0.tar.gz"))


###################################################
### code chunk number 8: cleanup
###################################################
setwd(pwd)


