/*
 * Decompiled with CFR 0.152.
 */
package reder.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reder.application.MainFrame;
import reder.network.EdgeBank;
import reder.network.NodeBank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadAttributes {
    private String openAddress = null;
    private String taskProgress = "running";
    private String attrType;
    protected static ArrayList<String> loadIDsA;
    protected static ArrayList<String> loadIDsB;
    protected static ArrayList<Integer> newLinksIDsA;
    protected static ArrayList<Integer> newLinksIDsB;
    protected static ArrayList<Integer> newLinksAtt;
    protected static ArrayList<Integer> newLinksAttSuppl;
    protected static ArrayList<Double> loadAttValue;
    protected static ArrayList<Double> loadAttValueSuppl;
    private double topAttValue = -1000000.0;
    private double botAttValue = 1000000.0;
    private static int numDepositos;
    private NodeBank nodeAccount;
    private EdgeBank edgeAccount;

    public LoadAttributes() {
        loadIDsA = new ArrayList();
        loadIDsB = new ArrayList();
        loadAttValue = new ArrayList();
        loadAttValueSuppl = new ArrayList();
        numDepositos = 0;
        newLinksIDsA = new ArrayList();
        newLinksIDsB = new ArrayList();
        newLinksAtt = new ArrayList();
        newLinksAttSuppl = new ArrayList();
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public int getLoadedNum() {
        return numDepositos;
    }

    public double getTopValue() {
        return this.topAttValue;
    }

    public double getbotAttValue() {
        return this.botAttValue;
    }

    public ArrayList<Integer> getNewLinksIDsA() {
        return newLinksIDsA;
    }

    public ArrayList<Integer> getNewLinksIDsB() {
        return newLinksIDsB;
    }

    public ArrayList<Integer> getNewEdgeAtt() {
        return newLinksAtt;
    }

    public ArrayList<Integer> getNewEdgeAttSuppl() {
        return newLinksAttSuppl;
    }

    public void inputAndGo(String openAddress, String attrType) {
        loadIDsA.clear();
        loadIDsB.clear();
        loadAttValue.clear();
        this.topAttValue = -1000000.0;
        this.botAttValue = 1000000.0;
        numDepositos = 0;
        this.openAddress = openAddress;
        this.attrType = attrType;
        try {
            this.loadAttributes();
            this.taskProgress = "endload";
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadAttributes() throws FileNotFoundException, IOException {
        String strLine = "";
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        Pattern nodePattern = Pattern.compile("^([^\\s]+)[\\s;]+([\\d\\.[-\\d\\.]]+)");
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([\\d\\.[-\\d\\.]]+)");
        Pattern edgePatternSuppl = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([\\d\\.[-\\d\\.]]+)[\\s;]+([\\d\\.]+)");
        if (this.attrType.equals("nodeatt")) {
            while (strLine != null) {
                Matcher matcher = nodePattern.matcher(strLine);
                if (matcher.find() && matcher.hitEnd()) {
                    String node = matcher.group(1);
                    double value = Double.parseDouble(matcher.group(2));
                    this.checkNodeAtt(node, value);
                }
                strLine = br.readLine();
            }
            this.addNodeAtt();
        } else if (this.attrType.equals("edgeatt")) {
            while (strLine != null) {
                Matcher matcher = edgePattern.matcher(strLine);
                if (matcher.find() && matcher.hitEnd()) {
                    String nodeA = matcher.group(1);
                    String nodeB = matcher.group(2);
                    double value = Double.parseDouble(matcher.group(3));
                    this.checkEdgeAtt(nodeA, nodeB, value);
                }
                strLine = br.readLine();
            }
            this.addEdgeAtt();
        }
    }

    private void checkNodeAtt(String node, double value) {
        if (MainFrame.keyNodeHash.containsKey(node)) {
            loadIDsA.add(node);
            loadAttValue.add(value);
            if (this.topAttValue < value) {
                this.topAttValue = value;
            }
            if (this.botAttValue > value) {
                this.botAttValue = value;
            }
        }
    }

    private void checkEdgeAtt(String nodeA, String nodeB, double value) {
        if (MainFrame.keyNodeHash.containsKey(nodeA) && MainFrame.keyNodeHash.containsKey(nodeB)) {
            loadIDsA.add(nodeA);
            loadIDsB.add(nodeB);
            loadAttValue.add(value);
            if (this.topAttValue < value) {
                this.topAttValue = value;
            }
            if (this.botAttValue > value) {
                this.botAttValue = value;
            }
        }
    }

    private void addNodeAtt() {
        for (int i = 0; i < loadIDsA.size(); ++i) {
            int deposito = (Integer)MainFrame.keyNodeHash.get(loadIDsA.get(i));
            this.nodeAccount = MainFrame.NodeList.get(deposito);
            this.nodeAccount.setNodeWeight(loadAttValue.get(i));
            ++numDepositos;
        }
    }

    private void addEdgeAtt() {
        for (int i = 0; i < loadIDsA.size(); ++i) {
            int depositoA = (Integer)MainFrame.keyNodeHash.get(loadIDsA.get(i));
            int depositoB = (Integer)MainFrame.keyNodeHash.get(loadIDsB.get(i));
            int size = MainFrame.EdgeList.size();
            for (int j = 0; j < size; ++j) {
                boolean condition2;
                this.edgeAccount = MainFrame.EdgeList.get(j);
                int nodeA = this.edgeAccount.getA();
                int nodeB = this.edgeAccount.getB();
                boolean condition1 = depositoA == nodeA && depositoB == nodeB;
                boolean bl = condition2 = depositoA == nodeB && depositoB == nodeA;
                if (!condition1 && !condition2) continue;
                this.edgeAccount.setEdgeWeight(loadAttValue.get(i));
                ++numDepositos;
            }
        }
    }
}

