
## @knitr setup, echo=FALSE
library(knitr)
options(width=80)


## @knitr wrap-hook, echo=FALSE
hook_output = knit_hooks$get('output')
knit_hooks$set(output = function(x, options) {
  # this hook is used only when the linewidth option is not NULL
  if (!is.null(n <- options$linewidth)) {
    x = knitr:::split_lines(x)
    # any lines wider than n should be wrapped
    if (any(nchar(x) > n)) x = strwrap(x, width = n)
    x = paste(x, collapse = '\n')
  }
  hook_output(x, options)
})


## @knitr listDatabases
library(KEGGREST)
listDatabases()


## @knitr get_organisms
org <- keggList("organism")
head(org)


## @knitr list_queryables
queryables <- c(listDatabases(), org[,1], org[,2])


## @knitr query_hsa, eval=FALSE
## keggList("hsa")


## @knitr keggGet
query <- keggGet(c("hsa:10458", "ece:Z5100"))


## @knitr querylength
length(query)


## @knitr explore
names(query[[1]])
query[[1]]$ENTRY
query[[1]]$DBLINKS


## @knitr aaseq
keggGet(c("hsa:10458", "ece:Z5100"), "aaseq") ## retrieves amino acid sequences


## @knitr ntseq
keggGet(c("hsa:10458", "ece:Z5100"), "ntseq") ## retrieves nucleotide sequences


## @knitr png
png <- keggGet("hsa05130", "image") 
t <- tempfile()
writePNG(png, t)
if (interactive()) browseURL(t)


## @knitr separate_keywords, linewidth=80
head(keggFind("genes", c("shiga", "toxin")))


## @knitr keyphrase, linewidth=80
head(keggFind("genes", "shiga toxin"))


## @knitr formula
head(keggFind("compound", "C7H10O5", "formula"))


## @knitr formula2
head(keggFind("compound", "O5C7", "formula"))


## @knitr exact_mass
keggFind("compound", 174.05, "exact_mass")


## @knitr mol_weight
head(keggFind("compound", 300:310, "mol_weight"))


## @knitr conv_with_ids
keggConv("ncbi-gi", c("hsa:10458", "ece:Z5100"))


## @knitr conv_species_kegg_to_geneid
head(keggConv("eco", "ncbi-geneid"))


## @knitr conv_species_geneid_to_kegg
head(keggConv("ncbi-geneid", "eco"))



## @knitr keggLink
head(keggLink("pathway", "hsa"))


## @knitr keggLink2
keggLink("pathway", c("hsa:10458", "ece:Z5100"))


