/*
 * Decompiled with CFR 0.152.
 */
package facs.scale;

import facs.scale.ArcsinhScale;
import facs.scale.ArcsinhScaleArgument;
import facs.scale.LinearScale;
import facs.scale.LnScale;
import facs.scale.LogScale;
import facs.scale.Scale;
import facs.scale.ScaleArgument;

public final class Scaling {
    public static final int LINEAR = 1;
    public static final int LOG = 2;
    public static final int LN = 3;
    public static final int ARCSINH = 4;
    public static final int BIEXP = 5;
    private static final int SCALE_COUNT = 3;
    private static final Scale LINEAR_SCALE = new LinearScale();
    private static final Scale LOG_SCALE = new LogScale();
    private static final Scale LN_SCALE = new LnScale();
    private static final Scale ARCSINH_SCALE = new ArcsinhScale();

    private Scaling() {
    }

    public static int[] getScaleFlags() {
        int[] flags = new int[]{1, 2, 4};
        return flags;
    }

    public static String getScaleLabel(int type) {
        switch (type) {
            case 1: {
                return "Linear";
            }
            case 2: {
                return "Log";
            }
            case 3: {
                return "Ln";
            }
            case 4: {
                return "Arcsinh";
            }
        }
        return "Unknown";
    }

    public static String getScaleDescription(int type) {
        switch (type) {
            case 1: {
                return "A linear scale.";
            }
            case 2: {
                return "A log scale of base 10.";
            }
            case 3: {
                return "A log scale of base e (Euler's constant).";
            }
            case 4: {
                return "An arcsinh scale.";
            }
        }
        return "Error: An error has occurred.";
    }

    public static Scale getScale(int type) {
        switch (type) {
            case 1: {
                return LINEAR_SCALE;
            }
            case 2: {
                return LOG_SCALE;
            }
            case 3: {
                return LN_SCALE;
            }
            case 4: {
                return ARCSINH_SCALE;
            }
        }
        return null;
    }

    public static ScaleArgument getScaleArgument(int type, String argument) {
        if (argument == null || argument.length() <= 0) {
            return null;
        }
        switch (type) {
            case 4: {
                return new ArcsinhScaleArgument(argument);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        int[] flags = Scaling.getScaleFlags();
        for (int i = 0; i < flags.length; ++i) {
            int flag = flags[i];
            System.out.print(Integer.toString(flag));
            System.out.print("\t");
            System.out.print(Scaling.getScaleLabel(flag));
            System.out.print("\t");
            System.out.print(Scaling.getScaleDescription(flag));
            System.out.println();
        }
        Scale scale = Scaling.getScale(4);
        ScaleArgument scaleArg = Scaling.getScaleArgument(4, "50");
        System.out.println("scale(1) = " + scale.getValue(1.0));
        System.out.println("scale(1) = " + scale.getValue(1.0, scaleArg));
        System.out.println("scale(10) = " + scale.getValue(10.0));
        System.out.println("scale(10) = " + scale.getValue(10.0, scaleArg));
        System.out.println("scale(10d) = " + scale.getValue(10.0));
        System.out.println("scale(10d) = " + scale.getValue(10.0, scaleArg));
        System.out.println("scale(100d) = " + scale.getValue(100.0));
        System.out.println("scale(100d) = " + scale.getValue(100.0, scaleArg));
        System.out.println("scale(1000d) = " + scale.getValue(1000.0));
        System.out.println("scale(1000d) = " + scale.getValue(1000.0, scaleArg));
        System.out.println("scale(10000d) = " + scale.getValue(10000.0));
        System.out.println("scale(10000d) = " + scale.getValue(10000.0, scaleArg));
        scaleArg = Scaling.getScaleArgument(4, "500");
        System.out.println("With argument at 500:");
        System.out.println("scale(1) = " + scale.getValue(1.0));
        System.out.println("scale(1) = " + scale.getValue(1.0, scaleArg));
        System.out.println("scale(10) = " + scale.getValue(10.0));
        System.out.println("scale(10) = " + scale.getValue(10.0, scaleArg));
        System.out.println("scale(10d) = " + scale.getValue(10.0));
        System.out.println("scale(10d) = " + scale.getValue(10.0, scaleArg));
        System.out.println("scale(100d) = " + scale.getValue(100.0));
        System.out.println("scale(100d) = " + scale.getValue(100.0, scaleArg));
        System.out.println("scale(1000d) = " + scale.getValue(1000.0));
        System.out.println("scale(1000d) = " + scale.getValue(1000.0, scaleArg));
        System.out.println("scale(10000d) = " + scale.getValue(10000.0));
        System.out.println("scale(10000d) = " + scale.getValue(10000.0, scaleArg));
    }
}

