### R code from vignette source 'r3Cseq.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width = 60)
olocale=Sys.setlocale(locale="C")


###################################################
### code chunk number 2: r3Cseq.Rnw:151-152
###################################################
library(r3Cseq)


###################################################
### code chunk number 3: r3Cseq.Rnw:155-159
###################################################
Aligned3CseqMybFetalBrain<-system.file("extdata",
		"alignedReads.fetal.brain.subset.bam",package="r3Cseq")
Aligned3CseqMybFetalLiver<-system.file("extdata",
		"alignedReads.fetal.liver.subset.bam",package="r3Cseq")


###################################################
### code chunk number 4: r3Cseq.Rnw:185-187
###################################################
expFile<-Aligned3CseqMybFetalLiver
contrFile<-Aligned3CseqMybFetalBrain


###################################################
### code chunk number 5: r3Cseq.Rnw:190-194
###################################################
my3Cseq.obj<-new("r3Cseq",organismName='mm9',alignedReadsBamExpFile=expFile,
		alignedReadsBamContrFile=contrFile,isControlInvolved=TRUE,
		isBamInputFile=TRUE,expLabel="fetal_liver",
		contrLabel="fetal_brain",restrictionEnzyme='HindIII')


###################################################
### code chunk number 6: r3Cseq.Rnw:200-201
###################################################
my3Cseq.obj	


###################################################
### code chunk number 7: r3Cseq.Rnw:206-207
###################################################
getReadCountPerRestrictionFragment(my3Cseq.obj)


###################################################
### code chunk number 8: r3Cseq.Rnw:216-217
###################################################
calculateRPM(my3Cseq.obj)	


###################################################
### code chunk number 9: r3Cseq.Rnw:222-223
###################################################
getInteractions(my3Cseq.obj)	


###################################################
### code chunk number 10: r3Cseq.Rnw:228-230
###################################################
fetal.liver.interactions <-expInteractionRegions(my3Cseq.obj)
fetal.liver.interactions


###################################################
### code chunk number 11: r3Cseq.Rnw:233-235
###################################################
fetal.brain.interactions <-	contrInteractionRegions(my3Cseq.obj)
fetal.brain.interactions


###################################################
### code chunk number 12: r3Cseq.Rnw:241-243
###################################################
viewpoint<-getViewpoint(my3Cseq.obj)
viewpoint


###################################################
### code chunk number 13: plotOverviewInteractions
###################################################
plotOverviewInteractions(my3Cseq.obj)	


###################################################
### code chunk number 14: plot3Cecdf
###################################################
plot3Cecdf(my3Cseq.obj)	


###################################################
### code chunk number 15: plotInteractionsNearViewpoint
###################################################
plotInteractionsNearViewpoint(my3Cseq.obj)	


###################################################
### code chunk number 16: plotInteractionsPerChromosome
###################################################
plotInteractionsPerChromosome(my3Cseq.obj,"chr10")	


###################################################
### code chunk number 17: r3Cseq.Rnw:303-304
###################################################
export3Cseq2bedGraph(my3Cseq.obj)	


###################################################
### code chunk number 18: r3Cseq.Rnw:311-312
###################################################
generate3CseqReport(my3Cseq.obj)	


###################################################
### code chunk number 19: r3Cseq.Rnw:317-318
###################################################
sessionInfo()


