### R code from vignette source 'netresponse.Rnw'

###################################################
### code chunk number 1: initial
###################################################
library(netresponse)
data(toydata)
D <- as.matrix(toydata$emat)
netw <- as.matrix(toydata$netw)


###################################################
### code chunk number 2: detect
###################################################
model <- detect.responses(D, netw, verbose = FALSE)


###################################################
### code chunk number 3: stat
###################################################
stat <- model.stats(model) 
stat


###################################################
### code chunk number 4: getsubnets2
###################################################
get.subnets(model, min.size = 2, min.responses = 2)


###################################################
### code chunk number 5: resp
###################################################
subnet.id <- 'Subnet-2'
response2sample(model, subnet.id)


###################################################
### code chunk number 6: pars
###################################################
pars <- get.model.parameters(model, subnet.id) # model parameters
pars


###################################################
### code chunk number 7: probs
###################################################
response.probabilities <- sample2response(model, subnet.id)


###################################################
### code chunk number 8: findsimilar
###################################################
g <- find.similar.features(model, subnet.id = "Subnet-1")
subset(g, delta < 0)


###################################################
### code chunk number 9: icmg
###################################################
library(netresponse)
data(osmo)
res <- ICMg.combined.sampler(osmo$ppi, osmo$exp, C=10)
res$comp.memb <- ICMg.get.comp.memberships(osmo$ppi, res)
res$clustering <- apply(res$comp.memb, 2, which.max)


###################################################
### code chunk number 10: visu1
###################################################
subnet.id <- "Subnet-2" # specify the subnet to visualize
vis <- plot.responses(model, subnet.id)


###################################################
### code chunk number 11: netresponse.Rnw:214-215
###################################################
plot.scale(vis$breaks, vis$palette)


###################################################
### code chunk number 12: details
###################################################
sessionInfo()


