### R code from vignette source 'maSigPro-tutorial.Rnw'

###################################################
### code chunk number 1: maSigPro-tutorial.Rnw:64-65
###################################################
library(maSigPro) # load maSigPro library


###################################################
### code chunk number 2: maSigPro-tutorial.Rnw:105-107
###################################################
data(data.abiotic)
data(edesign.abiotic)


###################################################
### code chunk number 3: maSigPro-tutorial.Rnw:110-111
###################################################
edesign.abiotic


###################################################
### code chunk number 4: maSigPro-tutorial.Rnw:139-140
###################################################
design <- make.design.matrix(edesign.abiotic, degree = 2)


###################################################
### code chunk number 5: maSigPro-tutorial.Rnw:147-148
###################################################
design$groups.vector


###################################################
### code chunk number 6: maSigPro-tutorial.Rnw:159-161
###################################################
fit <- p.vector(data.abiotic, design, Q = 0.05, MT.adjust = "BH", min.obs = 20)



###################################################
### code chunk number 7: maSigPro-tutorial.Rnw:179-180
###################################################
tstep <- T.fit(fit, step.method = "backward", alfa = 0.05)


###################################################
### code chunk number 8: maSigPro-tutorial.Rnw:220-222
###################################################
sigs <- get.siggenes(tstep, rsq = 0.6, vars = "groups")
sigs$summary


###################################################
### code chunk number 9: maSigPro-tutorial.Rnw:227-229
###################################################
names(sigs$sig.genes)
names(sigs$sig.genes$ColdvsControl)


###################################################
### code chunk number 10: venn1
###################################################
suma2Venn(sigs$summary[, c(2:4)])



###################################################
### code chunk number 11: maSigPro-tutorial.Rnw:256-257
###################################################
STMDE66 <- data.abiotic[rownames(data.abiotic)=="STMDE66", ]


###################################################
### code chunk number 12: plotGroups1
###################################################
PlotGroups (STMDE66, edesign = edesign.abiotic)


###################################################
### code chunk number 13: plotGroups2
###################################################
PlotGroups (STMDE66, edesign = edesign.abiotic, show.fit = T, dis = design$dis, groups.vector = design$groups.vector)


