### R code from vignette source 'crlmmDownstream.Rnw'

###################################################
### code chunk number 1: loadData
###################################################
library(oligoClasses)
library(VanillaICE)
library2(crlmm)
library2(SNPchip)
library2(IRanges)
data(cnSetExample, package="crlmm")


###################################################
### code chunk number 2: coerce2OligoSnpSet
###################################################
oligoList <- constructOligoSetListFrom(cnSetExample)


###################################################
### code chunk number 3: subset
###################################################
oligoSet <- oligoList[[1]]


###################################################
### code chunk number 4: hmm
###################################################
res <- hmm(oligoSet, p.hom=0.1, nupdates=5, TAUP=1e8)


###################################################
### code chunk number 5: xyplot
###################################################
rd <- res[chromosome(res) == "chr8", ]
rd <- res[!state(res)%in%c(3,4), ]
if(require(SNPchip)){
	fig <- xyplotLrrBaf(rd, oligoSet,
			    frame=200e3,
			    panel=xypanelBaf,
			    scales=list(x="free"),
			    par.strip.text=list(cex=0.9),
			    cex=0.4,
			    state.col="black",
			    state.cex=0.8,
			    pch=21)
}


###################################################
### code chunk number 6: latticeFig
###################################################
print(fig)


###################################################
### code chunk number 7: crlmmDownstream.Rnw:119-120
###################################################
toLatex(sessionInfo())


