### R code from vignette source 'SRAdb.Rnw'

###################################################
### code chunk number 1: init
###################################################
options(width=50)


###################################################
### code chunk number 2: SRAdb.Rnw:55-57
###################################################
library(SRAdb)
sqlfile <- getSRAdbFile()


###################################################
### code chunk number 3: SRAdb.Rnw:62-63
###################################################
file.info('SRAmetadb.sqlite')


###################################################
### code chunk number 4: SRAdb.Rnw:68-69
###################################################
sra_con <- dbConnect(SQLite(),sqlfile)


###################################################
### code chunk number 5: SRAdb.Rnw:79-81
###################################################
sra_tables <- dbListTables(sra_con)
sra_tables


###################################################
### code chunk number 6: SRAdb.Rnw:85-86
###################################################
dbListFields(sra_con,'study')


###################################################
### code chunk number 7: SRAdb.Rnw:90-91
###################################################
sqliteQuickSQL(sra_con,'PRAGMA TABLE_INFO(study)')


###################################################
### code chunk number 8: j1
###################################################
rs <- dbGetQuery(sra_con,'select * from study limit 3')
rs[, 1:3]


###################################################
### code chunk number 9: j2
###################################################
rs <- dbGetQuery(sra_con, paste( "select study_accession, 
        study_title from study where",
       "study_description like 'Transcriptome%'",sep=" "))
rs[1:3,]


###################################################
### code chunk number 10: SRAdb.Rnw:112-118
###################################################
getTableCounts <- function(tableName,conn) {
  sql <- sprintf("select count(*) from %s",tableName)
  return(dbGetQuery(conn,sql)[1,1])
}
do.call(rbind,sapply(sra_tables[1:3], 
	getTableCounts, sra_con, simplify=FALSE))


###################################################
### code chunk number 11: SRAdb.Rnw:127-129
###################################################
conversion <- sraConvert(c('SRP001007','SRP000931'), sra_con= sra_con)
conversion[1:3,]


###################################################
### code chunk number 12: SRAdb.Rnw:133-134
###################################################
apply(conversion, 2, unique)


###################################################
### code chunk number 13: SRAdb.Rnw:142-145
###################################################
rs <- getSRA (search_terms ='breast cancer', 
     out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### code chunk number 14: SRAdb.Rnw:149-152
###################################################
rs <- getSRA (search_terms ='"breast cancer"', 
     out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### code chunk number 15: SRAdb.Rnw:156-159
###################################################
rs <- getSRA (search_terms ='MCF7 OR "MCF-7"', 
     out_types=c('sample'), sra_con=sra_con) 
dim(rs)


###################################################
### code chunk number 16: SRAdb.Rnw:163-166
###################################################
rs <- getSRA (search_terms ='submission_center: GEO', 
     out_types=c('submission'), sra_con=sra_con)  
dim(rs)


###################################################
### code chunk number 17: SRAdb.Rnw:170-173
###################################################
rs <- getSRA (search_terms ='Carcino*', 
     out_types=c('study'), sra_con=sra_con)  
dim(rs)


###################################################
### code chunk number 18: SRAdb.Rnw:179-183 (eval = FALSE)
###################################################
## listSRAfile (in_acc = c("SRX000122"), 
##      sra_con = sra_con, fileType = 'sra')
## listSRAfile (in_acc = c("SRX000122"), 
##      sra_con = sra_con, fileType = 'sra', srcType='fasp')


###################################################
### code chunk number 19: SRAdb.Rnw:187-190 (eval = FALSE)
###################################################
## rs <- getSRAinfo (in_acc=c("SRX000122"), 
##      sra_con=sra_con)
## rs[1:3,]


###################################################
### code chunk number 20: SRAdb.Rnw:194-197 (eval = FALSE)
###################################################
## getSRAfile( in_acc = c("SRR000648","SRR000657"), 
##      sra_con = sra_con, destDir = getwd(), 
## 	 fileType = 'litesra' )


###################################################
### code chunk number 21: SRAdb.Rnw:202-203
###################################################
## system ("fastq-dump SRR000648.lite.sra")


###################################################
### code chunk number 22: SRAdb.Rnw:207-210 (eval = FALSE)
###################################################
## getFASTQinfo( in_acc = c("SRR000648","SRR000657"), srcType = 'ftp' )
## getSRAfile( in_acc, sra_con, destDir = getwd(), 
##      fileType = 'fastq', srcType = 'ftp' )


###################################################
### code chunk number 23: SRAdb.Rnw:217-226 (eval = FALSE)
###################################################
## ## List  fasp addresses of SRA fastq files associated with "SRX000122"
## listSRAfile (in_acc = c("SRX000122"), sra_con = sra_con, 
##      fileType = 'fastq', srcType='fasp')
## 
## ## download fastq files using fasp protocol:
## ascpCMD <-  'ascp -QT -l 300m -i 
##    /usr/local/aspera/connect/etc/asperaweb_id_dsa.putty'
## getSRAfile( in_acc = c("SRX000122"), sra_con,  
##      fileType = 'fastq', srcType = 'fasp',  ascpCMD = ascpCMD )


###################################################
### code chunk number 24: SRAdb.Rnw:230-244 (eval = FALSE)
###################################################
## ## List  fasp addresses of SRA litesra files associated with "SRX000122"
## listSRAfile (in_acc = c("SRX000122"), 
##      sra_con = sra_con, fileType = 'litesra', srcType='fasp')
## 
## ## download litesra files using fasp protocol:
## ascpCMD <- 'ascp -QT -l 300m -i 
##     /usr/local/aspera/connect/etc/asperaweb_id_dsa.putty'
## ## common ascpCMD for a system with Mac OS X:
## #ascpCMD <- "'/Applications/Aspera Connect.app
## #/Contents/Resources/ascp' -QT -l 300m -i 
## #'/Applications/Aspera Connect.app/Contents/
## #Resources/asperaweb_id_dsa.putty'"
## sraFiles <- ascpSRA( in_acc = c("SRX000122"), 
##      sra_con, ascpCMD, fileType = 'litesra', destDir=getwd() )


###################################################
### code chunk number 25: SRAdb.Rnw:253-254 (eval = FALSE)
###################################################
## startIGV("mm")


###################################################
### code chunk number 26: SRAdb.Rnw:258-265 (eval = FALSE)
###################################################
## exampleBams = file.path(system.file('extdata',package='SRAdb'),
##   dir(system.file('extdata',package='SRAdb'),pattern='bam$'))
## sock <- IGVsocket()
## IGVgenome(sock, 'hg18')
## IGVload(sock, exampleBams)
## IGVgoto(sock, 'chr1:1-1000')
## IGVsnapshot(sock)


###################################################
### code chunk number 27: SRAdb.Rnw:273-279 (eval = FALSE)
###################################################
## acc <- getSRA (search_terms ='primary thyroid cell line', 
##      out_types=c('sra'), sra_con=sra_con, acc_only=TRUE) 
## g <- entityGraph(acc)
## attrs <- getDefaultAttrs(list(node=list(
## 	 fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs= attrs)  


###################################################
### code chunk number 28: SRAdb.Rnw:283-288 (eval = FALSE)
###################################################
## g <- sraGraph('primary thyroid cell line', sra_con)
## library(Rgraphviz)
## attrs <- getDefaultAttrs(list(node=list(
## 	fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs=attrs)


###################################################
### code chunk number 29: SRAdb.Rnw:293-294
###################################################
dbDisconnect(sra_con)


###################################################
### code chunk number 30: SRAdb.Rnw:299-300
###################################################
toLatex(sessionInfo())


