### R code from vignette source 'QUALIFIER.Rnw'

###################################################
### code chunk number 1: loadPackage-QUALIFIER
###################################################
library(QUALIFIER)


###################################################
### code chunk number 2: parseWorkspace (eval = FALSE)
###################################################
## ws<-openWorkspace("./data/QA_MFI_RBC_bounary_eventsV3.xml")##should replace with your own xml workspace file path
## GT<-parseWorkspace(ws,execute=FALSE,useInternal=TRUE)


###################################################
### code chunk number 3: gh_template (eval = FALSE)
###################################################
## gh_template<-GT[[1]]					


###################################################
### code chunk number 4: gh_template (eval = FALSE)
###################################################
## ##datapath is the path where FCS files stores
## G<-GatingSet(gh_template,filenames,path="./data")
## getPopStats(G[[1]])


###################################################
### code chunk number 5: getQAStats (eval = FALSE)
###################################################
## db<-new.env()
## initDB(db)
## qaPreprocess(db=db,gs=G
## 			,metaFile="./data/FCS_File_mapping.csv" #should replace with your own FCS meta data file path
## 			,fcs.colname="FCS_Files"
## 			,date.colname=c("RecdDt","AnalysisDt")
## 	)


###################################################
### code chunk number 6: loadData
###################################################
data("ITNQASTUDY")


###################################################
### code chunk number 7: read.qaTask
###################################################
checkListFile<-file.path(system.file("data",package="QUALIFIER"),"qaCheckList.csv.gz")
qaTask.list<-read.qaTask(db,checkListFile=checkListFile)
qaTask.list[1:2]


###################################################
### code chunk number 8: qaTask-RBCLysis
###################################################
qaTask.list[["RBCLysis"]]


###################################################
### code chunk number 9: qaCheck-RBCLysis
###################################################
qaCheck(qaTask.list[["RBCLysis"]],outlierfunc=outlier.cutoff,lBound=0.8)


###################################################
### code chunk number 10: plot-RBCLysis
###################################################
plot(qaTask.list[["RBCLysis"]],xlab="Record Date",ylab="percent")


###################################################
### code chunk number 11: plot-RBCLysis-subset
###################################################
plot(qaTask.list[["RBCLysis"]],subset=Tube=='CD8/CD25/CD4/CD3/CD62L',xlab="Record Date",ylab="percent")


###################################################
### code chunk number 12: clearCheck
###################################################
clearCheck(qaTask.list[["RBCLysis"]])


###################################################
### code chunk number 13: plot-RBCLysis-subset2 (eval = FALSE)
###################################################
## plot(qaTask.list[["RBCLysis"]],subset=name=='06087181_F01_I010.fcs',scatterPlot=TRUE)


###################################################
### code chunk number 14: qaTask-MNC
###################################################
qaTask.list[["MNC"]]


###################################################
### code chunk number 15: qaCheck-MNC
###################################################
qaCheck(qaTask.list[["MNC"]],z.cutoff=1.5)


###################################################
### code chunk number 16: plot-MNC
###################################################
plot(qaTask.list[["MNC"]],proportion~factor(coresampleid),xlab="Sample ID",ylab="percent")


###################################################
### code chunk number 17: plot-MNC-scatter (eval = FALSE)
###################################################
## 
## plot(qaTask.list[["MNC"]]
## 		,scatterPlot=TRUE
## 		,subset=coresampleid==11730)


###################################################
### code chunk number 18: qaTask-BoundaryEvents
###################################################
qaTask.list[["BoundaryEvents"]]


###################################################
### code chunk number 19: qaCheck-BoundaryEvents
###################################################
qaCheck(qaTask.list[["BoundaryEvents"]]
		,sum(proportion) ~ RecdDt | name
		,outlierfunc=outlier.cutoff
		,uBound=0.0003
		)


###################################################
### code chunk number 20: plot-BoundaryEvents
###################################################
plot(qaTask.list[["BoundaryEvents"]],proportion ~ RecdDt | channel,xlab="Record Date",ylab="percent")


###################################################
### code chunk number 21: qaCheck-MFIOverTime
###################################################
qaCheck(qaTask.list[["MFIOverTime"]]
		,rFunc=rlm
		,z.cutoff=3
		)

plot(qaTask.list[["MFIOverTime"]]
		,y=MFI~RecdDt|stain
		,subset=channel%in%c('FITC-A')
		,rFunc=rlm
		,scales=list(y=c(relation="free"))
		,xlab="Record Date"
	)


###################################################
### code chunk number 22: plot-spike
###################################################
qaCheck(qaTask.list[["spike"]]
			,outlierfunc=outlier.t
			,alpha=0.00001)

plot(qaTask.list[["spike"]],y=spike~RecdDt|channel
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'&channel%in%c('FITC-A')
		,xlab="Record Date"
	)



###################################################
### code chunk number 23: tubesEvents
###################################################
tubesEvents<-read.csv(file.path(system.file("data",package="QUALIFIER"),"tubesevents.csv.gz"),row.names=1)
tubesEvents<-QUALIFIER:::.TubeNameMapping(db,tubesEvents=tubesEvents[,3,drop=F])


###################################################
### code chunk number 24: tubesEvents
###################################################
tubesEvents


###################################################
### code chunk number 25: plot-NumberOfEvents
###################################################
qaCheck(qaTask.list[["NumberOfEvents"]]
		,formula=count ~ RecdDt | Tube
		,outlierfunc=outlier.cutoff
		,lBound=0.8*tubesEvents
		)
plot(qaTask.list[["NumberOfEvents"]]
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'
		,xlab="Record Date"
		,ylab="Cell counts"
	)


###################################################
### code chunk number 26: plot-RedundantStain
###################################################
qaCheck(qaTask.list[["RedundantStain"]],z.cutoff=1)
plot(qaTask.list[["RedundantStain"]]
		,y=proportion~factor(coresampleid)|channel:stain
		,subset=stain%in%c('CD8')
		,scales=list(x=list(cex=0.5))
		,xlab="Sample ID"
		,ylab="percent"
	)


###################################################
### code chunk number 27: qa.report (eval = FALSE)
###################################################
## qaReport(qaTask.list
## 		,outDir="~/temp"
## 		,plotAll=FALSE
## 		,subset=as.POSIXlt(RecdDt)$year==(2007-1900)
## 		)
## 


###################################################
### code chunk number 28: qa.report (eval = FALSE)
###################################################
## htmlReport(qaTask.list[["MFIOverTime"]])<-TRUE
## rFunc(qaTask.list[["MFIOverTime"]])<-rlm
## scatterPar(qaTask.list[["MFIOverTime"]])<-list(xlog=TRUE)
## scatterPar(qaTask.list[["BoundaryEvents"]])<-list(xlog=TRUE)
## scatterPar(qaTask.list[["RedundantStain"]])<-list(xlog=TRUE)
## qpar(qaTask.list[["RedundantStain"]])<-list(scales=list(x=list(relation="free")))


