### R code from vignette source 'geneFunctionSummarize.Rnw'

###################################################
### code chunk number 1: Loading required libraries
###################################################
rm(list=ls())
library(GeneAnswers)
## load the DO data file, which includes several data sets.
data(DO)
## show the datasets included in DO.rda file
ls()


###################################################
### code chunk number 2: Summarize  the annotations of a particular gene
###################################################
# summarize the gene function
geneSummary <- geneFunSummarize('5037', gene2DO.map, DO.graph.closure.gene)
# simplify the summarized annotations to miniSet
geneSummary.sim <- simplifyGeneFunSummary(geneSummary, DO.graph.closure.gene, p.value.th=10^-5)
# print the miniSet
geneSummary.sim


###################################################
### code chunk number 3: geneFlashcard
###################################################
# plot the summarized annotation as a flashcard.
plotGeneFunSummary(geneSummary, onto.graph=DO.graph.gene, onto.graph.closure=DO.graph.closure.gene, ID2Name=DO.terms, p.value.th=0.0001, miniSetPvalue=10^-5, saveImage=FALSE)


###################################################
### code chunk number 4: Summarize  the annotations of all genes in DO database (eval = FALSE)
###################################################
## # retrieve all genes in the DO database from gene2DO.map list
## allGenes <- names(gene2DO.map) 
## length(allGenes)
## # summarize all genes in a batch
## geneSummary.all <- geneFunSummarize(allGenes, gene2DO.map, DO.graph.closure.gene, fdr.adjust='fdr')
## # simplify the summarized annotation as the miniSet
## sim.geneSummary.d.all <- simplifyGeneFunSummary(geneSummary.all, DO.graph.closure.gene, allOntoID.direct=names(DO2gene.direct), p.value.th=10^-5)
## # save the summarized annotations in a tab-separated text file.
## saveGeneFunSummary(geneSummary.all, simplifyInfo=sim.geneSummary.d.all, ID2Name=DO.terms, fileName="geneSummarization_all.xls")


###################################################
### code chunk number 5: sessionInfo
###################################################
toLatex(sessionInfo())


