/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.converter.ValueToStringConverterManager;
import cytoscape.visual.parsers.ColorParser;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.Properties;

public class GlobalAppearanceCalculator
extends SubjectBase
implements Cloneable {
    private Color defaultBackgroundColor = Color.WHITE;
    private Color defaultNodeSelectionColor = Color.YELLOW;
    private Color defaultNodeReverseSelectionColor = Color.GREEN;
    private Color defaultEdgeSelectionColor = Color.RED;
    private Color defaultEdgeReverseSelectionColor = Color.GREEN;

    public Object clone() throws CloneNotSupportedException {
        GlobalAppearanceCalculator copy = new GlobalAppearanceCalculator();
        copy.setDefaultBackgroundColor(this.defaultBackgroundColor);
        copy.setDefaultNodeSelectionColor(this.defaultNodeSelectionColor);
        copy.setDefaultEdgeSelectionColor(this.defaultEdgeSelectionColor);
        copy.setDefaultNodeReverseSelectionColor(this.defaultNodeReverseSelectionColor);
        copy.setDefaultEdgeReverseSelectionColor(this.defaultEdgeReverseSelectionColor);
        return copy;
    }

    public GlobalAppearanceCalculator() {
    }

    public Color getDefaultColor(String name) throws Exception {
        Class<?> cls = this.getClass();
        String newName = name.replace(" ", "");
        Method method = cls.getMethod("getDefault" + newName, new Class[0]);
        Object obj = method.invoke((Object)this, new Object[0]);
        if (obj != null && obj instanceof Color) {
            return (Color)obj;
        }
        return null;
    }

    public void setDefaultColor(String name, Color newColor) throws Exception {
        Class<?> cls = this.getClass();
        String newName = name.replace(" ", "");
        Method method = cls.getMethod("setDefault" + newName, Color.class);
        method.invoke((Object)this, newColor);
    }

    public static String[] getGlobalAppearanceNames() {
        return GlobalAppearance.getCalculatorNames();
    }

    public GlobalAppearanceCalculator(GlobalAppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setDefaultBackgroundColor(toCopy.getDefaultBackgroundColor());
        this.setDefaultNodeSelectionColor(toCopy.getDefaultNodeSelectionColor());
        this.setDefaultNodeReverseSelectionColor(toCopy.getDefaultNodeReverseSelectionColor());
        this.setDefaultEdgeSelectionColor(toCopy.getDefaultEdgeSelectionColor());
        this.setDefaultEdgeReverseSelectionColor(toCopy.getDefaultEdgeReverseSelectionColor());
    }

    public GlobalAppearanceCalculator(String name, Properties gProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(name, gProps, baseKey, catalog);
    }

    public GlobalAppearance calculateGlobalAppearance(CyNetwork network) {
        GlobalAppearance appr = new GlobalAppearance();
        this.calculateGlobalAppearance(appr, network);
        return appr;
    }

    public void calculateGlobalAppearance(GlobalAppearance appr, CyNetwork network) {
        appr.setBackgroundColor(this.calculateBackgroundColor(network));
        appr.setNodeSelectionColor(this.calculateNodeSelectionColor(network));
        appr.setNodeReverseSelectionColor(this.calculateNodeReverseSelectionColor(network));
        appr.setEdgeSelectionColor(this.calculateEdgeSelectionColor(network));
        appr.setEdgeReverseSelectionColor(this.calculateEdgeReverseSelectionColor(network));
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        if (c != null) {
            this.defaultBackgroundColor = c;
            this.fireStateChanged();
        }
    }

    public Color calculateBackgroundColor(CyNetwork network) {
        return this.defaultBackgroundColor;
    }

    public Color getDefaultNodeSelectionColor() {
        return this.defaultNodeSelectionColor;
    }

    public void setDefaultNodeSelectionColor(Color c) {
        if (c != null) {
            this.defaultNodeSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultNodeReverseSelectionColor() {
        return this.defaultNodeReverseSelectionColor;
    }

    public void setDefaultNodeReverseSelectionColor(Color c) {
        if (c != null) {
            this.defaultNodeReverseSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultEdgeSelectionColor() {
        return this.defaultEdgeSelectionColor;
    }

    public void setDefaultEdgeSelectionColor(Color c) {
        if (c != null) {
            this.defaultEdgeSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultEdgeReverseSelectionColor() {
        return this.defaultEdgeReverseSelectionColor;
    }

    public void setDefaultEdgeReverseSelectionColor(Color c) {
        if (c != null) {
            this.defaultEdgeReverseSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color calculateNodeSelectionColor(CyNetwork network) {
        return this.defaultNodeSelectionColor;
    }

    public Color calculateNodeReverseSelectionColor(CyNetwork network) {
        return this.defaultNodeReverseSelectionColor;
    }

    public Color calculateEdgeSelectionColor(CyNetwork network) {
        return this.defaultEdgeSelectionColor;
    }

    public Color calculateEdgeReverseSelectionColor(CyNetwork network) {
        return this.defaultEdgeReverseSelectionColor;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("GlobalAppearanceCalculator:" + lineSep);
        sb.append("defaultBackgroundColor = ");
        sb.append(this.defaultBackgroundColor).append(lineSep);
        return sb.toString();
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        Color c;
        String value = null;
        value = nacProps.getProperty(baseKey + ".defaultBackgroundColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultBackgroundColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeReverseSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeReverseSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultEdgeSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultEdgeSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultEdgeReverseSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultEdgeReverseSelectionColor(c);
        }
    }

    public Properties getProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultBackgroundColor";
        value = ValueToStringConverterManager.manager.toString(this.getDefaultBackgroundColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeSelectionColor";
        value = ValueToStringConverterManager.manager.toString(this.getDefaultNodeSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeReverseSelectionColor";
        value = ValueToStringConverterManager.manager.toString(this.getDefaultNodeReverseSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeSelectionColor";
        value = ValueToStringConverterManager.manager.toString(this.getDefaultEdgeSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeReverseSelectionColor";
        value = ValueToStringConverterManager.manager.toString(this.getDefaultEdgeReverseSelectionColor());
        newProps.setProperty(key, value);
        return newProps;
    }
}

