/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree.test;

import cytoscape.geom.rtree.RTree;
import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.util.intr.MinIntHeap;
import java.io.IOException;
import java.io.InputStream;

public class RTreeQueryPerformance {
    public static void main(String[] args) throws Exception {
        int i;
        int i2;
        int i3;
        int read;
        int branches = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        RTree tree = new RTree(branches);
        double sqrtN = Math.sqrt(N);
        InputStream in = System.in;
        byte[] buff = new byte[16];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            int nonnegative = Integer.MAX_VALUE & RTreeQueryPerformance.assembleInt(buff, 0);
            double centerX = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeQueryPerformance.assembleInt(buff, 4);
            double centerY = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeQueryPerformance.assembleInt(buff, 8);
            double width = (double)nonnegative / 2.147483647E9 / sqrtN;
            nonnegative = Integer.MAX_VALUE & RTreeQueryPerformance.assembleInt(buff, 12);
            double height = (double)nonnegative / 2.147483647E9 / sqrtN;
            tree.insert(inx, (float)(centerX - width / 2.0), (float)(centerY - height / 2.0), (float)(centerX + width / 2.0), (float)(centerY + height / 2.0));
            ++inx;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        MinIntHeap[] pointQueries = new MinIntHeap[121];
        for (i3 = 0; i3 < pointQueries.length; ++i3) {
            pointQueries[i3] = new MinIntHeap();
        }
        for (i3 = 0; i3 < 3; ++i3) {
            System.gc();
            Thread.sleep(1000L);
        }
        long millisBegin = System.currentTimeMillis();
        int inx2 = 0;
        float currX = -0.1f;
        for (int i4 = 0; i4 < 11; ++i4) {
            currX += 0.1f;
            float currY = -0.1f;
            for (int j = 0; j < 11; ++j) {
                SpacialEntry2DEnumerator iter = tree.queryOverlap(currX, currY += 0.1f, currX, currY, null, 0, false);
                MinIntHeap heap = pointQueries[inx2++];
                while (iter.numRemaining() > 0) {
                    heap.toss(iter.nextInt());
                }
            }
        }
        long millisEnd = System.currentTimeMillis();
        System.err.println("point queries took " + (millisEnd - millisBegin) + " milliseconds");
        MinIntHeap[] areaQueries = new MinIntHeap[5];
        for (i2 = 0; i2 < areaQueries.length; ++i2) {
            areaQueries[i2] = new MinIntHeap();
        }
        for (i2 = 0; i2 < 3; ++i2) {
            System.gc();
            Thread.sleep(1000L);
        }
        long millisBegin2 = System.currentTimeMillis();
        for (int i5 = 0; i5 < 5; ++i5) {
            SpacialEntry2DEnumerator iter = tree.queryOverlap((float)i5 * 0.1f, (float)i5 * 0.1f, (float)(i5 + 1) * 0.1f, (float)(i5 + 1) * 0.1f, null, 0, false);
            MinIntHeap heap = areaQueries[i5];
            while (iter.numRemaining() > 0) {
                heap.toss(iter.nextInt());
            }
        }
        long millisEnd2 = System.currentTimeMillis();
        System.err.println("area queries took " + (millisEnd2 - millisBegin2) + " milliseconds");
        int[] countQueries = new int[5];
        for (int i6 = 0; i6 < 3; ++i6) {
            System.gc();
            Thread.sleep(1000L);
        }
        long millisBegin3 = System.currentTimeMillis();
        for (int i7 = 0; i7 < 5; ++i7) {
            SpacialEntry2DEnumerator iter = tree.queryOverlap((float)i7 * 0.1f, (float)i7 * 0.1f, (float)(i7 + 6) * 0.1f, (float)(i7 + 6) * 0.1f, null, 0, false);
            countQueries[i7] = iter.numRemaining();
        }
        millisEnd = System.currentTimeMillis();
        System.err.println("count queries took " + (millisEnd - millisBegin3) + " milliseconds");
        for (i = 0; i < pointQueries.length; ++i) {
            MinIntHeap heap = pointQueries[i];
            while (heap.size() > 0) {
                System.out.print(" " + heap.deleteMin());
            }
            System.out.println();
        }
        for (i = 0; i < areaQueries.length; ++i) {
            MinIntHeap heap = areaQueries[i];
            while (heap.size() > 0) {
                System.out.print(" " + heap.deleteMin());
            }
            System.out.println();
        }
        for (i = 0; i < countQueries.length; ++i) {
            System.out.println(countQueries[i]);
        }
    }

    private static int assembleInt(byte[] bytes, int offset) {
        int firstByte = (bytes[offset] & 0xFF) << 24;
        int secondByte = (bytes[offset + 1] & 0xFF) << 16;
        int thirdByte = (bytes[offset + 2] & 0xFF) << 8;
        int fourthByte = (bytes[offset + 3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }
}

