/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.visualize.MatrixPanel;

public class AttributeSelectionPanel
extends JPanel {
    protected GenericObjectEditor m_AttributeEvaluatorEditor = new GenericObjectEditor();
    protected GenericObjectEditor m_AttributeSearchEditor = new GenericObjectEditor();
    protected PropertyPanel m_AEEPanel = new PropertyPanel(this.m_AttributeEvaluatorEditor);
    protected PropertyPanel m_ASEPanel = new PropertyPanel(this.m_AttributeSearchEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JRadioButton m_CVBut = new JRadioButton("Cross-validation");
    protected JRadioButton m_TrainBut = new JRadioButton("Use full training set");
    protected JLabel m_CVLab = new JLabel("Folds", 4);
    protected JTextField m_CVText = new JTextField("10");
    protected JLabel m_SeedLab = new JLabel("Seed", 4);
    protected JTextField m_SeedText = new JTextField("1");
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            AttributeSelectionPanel.this.updateRadioLinks();
        }
    };
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    private Dimension COMBO_SIZE;
    protected Instances m_Instances;
    protected Thread m_RunThread;

    public AttributeSelectionPanel() {
        this.COMBO_SIZE = new Dimension(150, this.m_StartBut.getPreferredSize().height);
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    AttributeSelectionPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_AttributeEvaluatorEditor.setClassType(ASEvaluation.class);
        this.m_AttributeEvaluatorEditor.setValue(new CfsSubsetEval());
        this.m_AttributeEvaluatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    if (!(AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker)) {
                        Object object = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                        int n = JOptionPane.showConfirmDialog(null, "You must use use the Ranker search method in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the Ranker search method for you?", "Alert!", 0);
                        if (n == 0) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new Ranker());
                        } else if (object != null) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(object);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    Object object = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                    int n = JOptionPane.showConfirmDialog(null, "You must use use a search method that explores \nthe space of attribute subsets (such as GreedyStepwise) in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the GreedyStepwise search method for " + "you?\n(you can always switch to a different method afterwards)", "Alert!", 0);
                    if (n == 0) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new GreedyStepwise());
                    } else if (object != null) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(object);
                    }
                }
                AttributeSelectionPanel.this.updateRadioLinks();
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_AttributeSearchEditor.setClassType(ASSearch.class);
        this.m_AttributeSearchEditor.setValue(new BestFirst());
        this.m_AttributeSearchEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    if (!(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator)) {
                        Object object = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                        int n = JOptionPane.showConfirmDialog(null, "You must use use an evaluator that evaluates\nsingle attributes (such as InfoGain) in order to use\nthe Ranker. Should I select the InfoGain evaluator for you?\n(You can always switch to a different method afterwards)", "Alert!", 0);
                        if (n == 0) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new InfoGainAttributeEval());
                        } else if (object != null) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(object);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    Object object = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                    int n = JOptionPane.showConfirmDialog(null, "You must use use an evaluator that evaluates\nsubsets of attributes (such as CFS) in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the CFS subset evaluator for you?" + "\n(you can always switch to a different method afterwards)", "Alert!", 0);
                    if (n == 0) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new CfsSubsetEval());
                    } else if (object != null) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(object);
                    }
                }
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_ClassCombo.setToolTipText("Select the attribute to use as the class");
        this.m_TrainBut.setToolTipText("select attributes using the full training dataset");
        this.m_CVBut.setToolTipText("Perform a n-fold cross-validation");
        this.m_StartBut.setToolTipText("Starts attribute selection");
        this.m_StopBut.setToolTipText("Stops a attribute selection task");
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_History.setPreferredSize(this.COMBO_SIZE);
        this.m_History.setMaximumSize(this.COMBO_SIZE);
        this.m_History.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_TrainBut.setSelected(true);
        this.updateRadioLinks();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_TrainBut);
        buttonGroup.add(this.m_CVBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_CVBut.addActionListener(this.m_RadioListener);
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.startAttributeSelection();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.stopAttributeSelection();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    int n = AttributeSelectionPanel.this.m_History.getList().locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        String string = AttributeSelectionPanel.this.m_History.getNameAtIndex(n);
                        AttributeSelectionPanel.this.visualize(string, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        AttributeSelectionPanel.this.visualize(null, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Attribute Evaluator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_AEEPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Search Method"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_ASEPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Attribute Selection Mode"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TrainBut, gridBagConstraints);
        jPanel4.add(this.m_TrainBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_CVBut, gridBagConstraints);
        jPanel4.add(this.m_CVBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_CVLab, gridBagConstraints);
        jPanel4.add(this.m_CVLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_CVText, gridBagConstraints);
        jPanel4.add(this.m_CVText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_SeedLab, gridBagConstraints);
        jPanel4.add(this.m_SeedLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_SeedText, gridBagConstraints);
        jPanel4.add(this.m_SeedText);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 2));
        jPanel5.add(this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel6.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel6.add(this.m_StartBut);
        jPanel6.add(this.m_StopBut);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Attribute selection output"));
        jPanel7.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutText);
        jPanel7.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        JPanel jPanel8 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel8.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel8.add(jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel8.add(jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(this.m_History, gridBagConstraints);
        jPanel8.add(this.m_History);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel8.add(jPanel7);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel8, "Center");
    }

    protected void updateRadioLinks() {
        this.m_CVBut.setEnabled(true);
        this.m_CVText.setEnabled(this.m_CVBut.isSelected());
        this.m_CVLab.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedText.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedLab.setEnabled(this.m_CVBut.isSelected());
        if (this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeTransformer) {
            this.m_CVBut.setSelected(false);
            this.m_CVBut.setEnabled(false);
            this.m_CVText.setEnabled(false);
            this.m_CVLab.setEnabled(false);
            this.m_SeedText.setEnabled(false);
            this.m_SeedLab.setEnabled(false);
            this.m_TrainBut.setSelected(true);
        }
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        String[] stringArray = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    string = "(Nom) ";
                    break;
                }
                case 0: {
                    string = "(Num) ";
                    break;
                }
                case 2: {
                    string = "(Str) ";
                    break;
                }
                case 3: {
                    string = "(Dat) ";
                    break;
                }
                default: {
                    string = "(???) ";
                }
            }
            String string2 = this.m_Instances.attribute(i).name();
            stringArray[i] = string + string2;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_ClassCombo.setSelectedIndex(stringArray.length - 1);
        this.m_ClassCombo.setEnabled(true);
    }

    protected void startAttributeSelection() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block50: {
                        AttributeSelectionPanel.this.m_Log.statusMessage("Setting up...");
                        Instances instances = new Instances(AttributeSelectionPanel.this.m_Instances);
                        int n = 0;
                        int n2 = 10;
                        int n3 = 1;
                        int n4 = AttributeSelectionPanel.this.m_ClassCombo.getSelectedIndex();
                        ASEvaluation aSEvaluation = (ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue();
                        ASSearch aSSearch = (ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue();
                        StringBuffer stringBuffer = new StringBuffer();
                        String string = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                        String string2 = aSSearch.getClass().getName();
                        string = string2.startsWith("weka.attributeSelection.") ? string + string2.substring("weka.attributeSelection.".length()) : string + string2;
                        String string3 = aSEvaluation.getClass().getName();
                        string = string3.startsWith("weka.attributeSelection.") ? string + " + " + string3.substring("weka.attributeSelection.".length()) : string + " + " + string3;
                        AttributeSelection attributeSelection = null;
                        try {
                            String[] stringArray;
                            if (AttributeSelectionPanel.this.m_CVBut.isSelected()) {
                                n = 1;
                                n2 = Integer.parseInt(AttributeSelectionPanel.this.m_CVText.getText());
                                n3 = Integer.parseInt(AttributeSelectionPanel.this.m_SeedText.getText());
                                if (n2 <= 1) {
                                    throw new Exception("Number of folds must be greater than 1");
                                }
                            }
                            instances.setClassIndex(n4);
                            AttributeSelectionPanel.this.m_Log.logMessage("Started " + string3);
                            if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskStarted();
                            }
                            stringBuffer.append("=== Run information ===\n\n");
                            stringBuffer.append("Evaluator:    " + string3);
                            if (aSEvaluation instanceof OptionHandler) {
                                stringArray = ((OptionHandler)((Object)aSEvaluation)).getOptions();
                                stringBuffer.append(" " + Utils.joinOptions(stringArray));
                            }
                            stringBuffer.append("\nSearch:       " + string2);
                            if (aSSearch instanceof OptionHandler) {
                                stringArray = ((OptionHandler)((Object)aSSearch)).getOptions();
                                stringBuffer.append(" " + Utils.joinOptions(stringArray));
                            }
                            stringBuffer.append("\n");
                            stringBuffer.append("Relation:     " + instances.relationName() + '\n');
                            stringBuffer.append("Instances:    " + instances.numInstances() + '\n');
                            stringBuffer.append("Attributes:   " + instances.numAttributes() + '\n');
                            if (instances.numAttributes() < 100) {
                                for (int i = 0; i < instances.numAttributes(); ++i) {
                                    stringBuffer.append("              " + instances.attribute(i).name() + '\n');
                                }
                            } else {
                                stringBuffer.append("              [list of attributes omitted]\n");
                            }
                            stringBuffer.append("Evaluation mode:    ");
                            switch (n) {
                                case 0: {
                                    stringBuffer.append("evaluate on all training data\n");
                                    break;
                                }
                                case 1: {
                                    stringBuffer.append("" + n2 + "-fold cross-validation\n");
                                }
                            }
                            stringBuffer.append("\n");
                            AttributeSelectionPanel.this.m_History.addResult(string, stringBuffer);
                            AttributeSelectionPanel.this.m_History.setSingle(string);
                            AttributeSelectionPanel.this.m_Log.statusMessage("Doing feature selection...");
                            AttributeSelectionPanel.this.m_History.updateResult(string);
                            attributeSelection = new AttributeSelection();
                            attributeSelection.setEvaluator(aSEvaluation);
                            attributeSelection.setSearch(aSSearch);
                            attributeSelection.setFolds(n2);
                            attributeSelection.setSeed(n3);
                            if (n == 1) {
                                attributeSelection.setXval(true);
                            }
                            switch (n) {
                                case 0: {
                                    AttributeSelectionPanel.this.m_Log.statusMessage("Evaluating on training data...");
                                    attributeSelection.SelectAttributes(instances);
                                    break;
                                }
                                case 1: {
                                    AttributeSelectionPanel.this.m_Log.statusMessage("Randomizing instances...");
                                    Random random = new Random(n3);
                                    instances.randomize(random);
                                    if (instances.attribute(n4).isNominal()) {
                                        AttributeSelectionPanel.this.m_Log.statusMessage("Stratifying instances...");
                                        instances.stratify(n2);
                                    }
                                    for (int i = 0; i < n2; ++i) {
                                        AttributeSelectionPanel.this.m_Log.statusMessage("Creating splits for fold " + (i + 1) + "...");
                                        Instances instances2 = instances.trainCV(n2, i, random);
                                        AttributeSelectionPanel.this.m_Log.statusMessage("Selecting attributes using all but fold " + (i + 1) + "...");
                                        attributeSelection.selectAttributesCVSplit(instances2);
                                    }
                                    break;
                                }
                                default: {
                                    throw new Exception("Test mode not implemented");
                                }
                            }
                            if (n == 0) {
                                stringBuffer.append(attributeSelection.toResultsString());
                            } else {
                                stringBuffer.append(attributeSelection.CVResultsString());
                            }
                            stringBuffer.append("\n");
                            AttributeSelectionPanel.this.m_History.updateResult(string);
                            AttributeSelectionPanel.this.m_Log.logMessage("Finished " + string3 + " " + string2);
                            AttributeSelectionPanel.this.m_Log.statusMessage("OK");
                            Object var17_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_21 = null;
                            if (aSEvaluation instanceof AttributeTransformer) {
                                try {
                                    Instances instances3 = ((AttributeTransformer)((Object)aSEvaluation)).transformedData();
                                    instances3.setRelationName("AT: " + instances3.relationName());
                                    FastVector fastVector = new FastVector();
                                    fastVector.addElement(instances3);
                                    AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                                }
                                catch (Exception exception) {
                                    System.err.println(exception);
                                    exception.printStackTrace();
                                }
                            } else if (n == 0) {
                                try {
                                    Instances instances4 = attributeSelection.reduceDimensionality(instances);
                                    FastVector fastVector = new FastVector();
                                    fastVector.addElement(instances4);
                                    AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (this.isInterrupted()) {
                                AttributeSelectionPanel.this.m_Log.logMessage("Interrupted " + string3 + " " + string2);
                                AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                            }
                            AttributeSelectionPanel.this.m_RunThread = null;
                            AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                            AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                            if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                        if (aSEvaluation instanceof AttributeTransformer) {
                            try {
                                Instances instances5 = ((AttributeTransformer)((Object)aSEvaluation)).transformedData();
                                instances5.setRelationName("AT: " + instances5.relationName());
                                FastVector fastVector = new FastVector();
                                fastVector.addElement(instances5);
                                AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                            }
                            catch (Exception exception) {
                                System.err.println(exception);
                                exception.printStackTrace();
                            }
                        } else if (n == 0) {
                            try {
                                Instances instances6 = attributeSelection.reduceDimensionality(instances);
                                FastVector fastVector = new FastVector();
                                fastVector.addElement(instances6);
                                AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (this.isInterrupted()) {
                            AttributeSelectionPanel.this.m_Log.logMessage("Interrupted " + string3 + " " + string2);
                            AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                        }
                        AttributeSelectionPanel.this.m_RunThread = null;
                        AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                        AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                        if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                        }
                        break block50;
                        {
                            catch (Exception exception) {
                                AttributeSelectionPanel.this.m_Log.logMessage(exception.getMessage());
                                AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                                Object var17_20 = null;
                                if (aSEvaluation instanceof AttributeTransformer) {
                                    try {
                                        Instances instances7 = ((AttributeTransformer)((Object)aSEvaluation)).transformedData();
                                        instances7.setRelationName("AT: " + instances7.relationName());
                                        FastVector fastVector = new FastVector();
                                        fastVector.addElement(instances7);
                                        AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                                    }
                                    catch (Exception exception2) {
                                        System.err.println(exception2);
                                        exception2.printStackTrace();
                                    }
                                } else if (n == 0) {
                                    try {
                                        Instances instances8 = attributeSelection.reduceDimensionality(instances);
                                        FastVector fastVector = new FastVector();
                                        fastVector.addElement(instances8);
                                        AttributeSelectionPanel.this.m_History.addObject(string, fastVector);
                                    }
                                    catch (Exception exception3) {
                                        exception3.printStackTrace();
                                    }
                                }
                                if (this.isInterrupted()) {
                                    AttributeSelectionPanel.this.m_Log.logMessage("Interrupted " + string3 + " " + string2);
                                    AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                                }
                                AttributeSelectionPanel.this.m_RunThread = null;
                                AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                                AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                                if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAttributeSelection() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String string) {
        StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
        if (stringBuffer != null && this.m_SaveOut.save(stringBuffer)) {
            this.m_Log.logMessage("Save succesful.");
        }
    }

    protected void visualizeTransformedData(Instances instances) {
        if (instances != null) {
            MatrixPanel matrixPanel = new MatrixPanel();
            matrixPanel.setInstances(instances);
            String string = instances.relationName();
            final JFrame jFrame = new JFrame("Weka Attribute Selection Visualize: " + string);
            jFrame.setSize(800, 600);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)matrixPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
    }

    protected void visualize(String string, int n, int n2) {
        Object object;
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("View in main window");
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttributeSelectionPanel.this.m_History.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("View in separate window");
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttributeSelectionPanel.this.m_History.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save result buffer");
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttributeSelectionPanel.this.saveBuffer(string2);
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        FastVector fastVector = null;
        if (string2 != null) {
            fastVector = (FastVector)this.m_History.getNamedObject(string2);
        }
        Instances instances = null;
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                object = fastVector.elementAt(i);
                if (!(object instanceof Instances)) continue;
                instances = (Instances)object;
            }
        }
        final Instances instances2 = instances;
        object = null;
        if (instances2 != null) {
            object = instances2.relationName().startsWith("AT:") ? new JMenuItem("Visualize transformed data") : new JMenuItem("Visualize reduced data");
            jPopupMenu.addSeparator();
        }
        if (instances2 != null && object != null) {
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttributeSelectionPanel.this.visualizeTransformedData(instances2);
                }
            });
        }
        if (object != null) {
            jPopupMenu.add((JMenuItem)object);
        }
        jPopupMenu.show(this.m_History.getList(), n, n2);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Select attributes");
            jFrame.getContentPane().setLayout(new BorderLayout());
            AttributeSelectionPanel attributeSelectionPanel = new AttributeSelectionPanel();
            jFrame.getContentPane().add((Component)attributeSelectionPanel, "Center");
            LogPanel logPanel = new LogPanel();
            attributeSelectionPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                attributeSelectionPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

