library(minfi)
manifest.file <- "/thumper2/feinbergLab/personal/khansen/450k/data/HumanMethylation450_15017482_v.1.1_ForExcel.csv"
maniTmp <- minfi:::read.manifest(manifest.file, returnAll = TRUE)

## Manifest package

IlluminaHumanMethylation450kmanifest <- manifestNew(TypeI = maniTmp$manifestList$TypeI,
                                                    TypeII = maniTmp$manifestList$TypeII,
                                                    TypeControl = maniTmp$manifestList$TypeControl,
                                                    annotation = "IlluminaHumanMethylation450k")
save(IlluminaHumanMethylation450kmanifest, # compress = "xz",
     file = "IlluminaHumanMethylation450kmanifest.rda")

## Annotation package

anno <- maniTmp$manifest
anno$IlmnID <- NULL
nam <- names(anno)
names(nam) <- nam
nam[c("AddressA_ID", "AddressB_ID", "AlleleA_ProbeSeq", "AlleleB_ProbeSeq",
            "Infinium_Design_Type", "Next_Base", "Color_Channel")] <-  c("AddressA", "AddressB",
                                                                         "ProbeSeqA", "ProbeSeqB",
                                                                         "Type", "NextBase", "Color")
names(nam) <- NULL
names(anno) <- nam
rownames(anno) <- anno$Name
anno <- anno[getManifestInfo(IlluminaHumanMethylation450kmanifest, type = "locusNames"),]

Locations.hg18 <- anno[, c("Chromosome_36", "Coordinate_36")]
names(Locations.hg18) <- c("chr", "pos")
Locations.hg18$pos <- as.integer(Locations.hg18$pos)
Locations.hg18$chr <- paste("chr", Locations.hg18$chr, sep = "")
rownames(Locations.hg18) <- anno$Name

Locations.hg19 <- anno[, c("CHR", "MAPINFO")]
names(Locations.hg19) <- c("chr", "pos")
Locations.hg19$pos <- as.integer(Locations.hg19$pos)
Locations.hg19$chr <- paste("chr", Locations.hg19$chr, sep = "")
rownames(Locations.hg19) <- anno$Name

everything <- anno[, ! names(anno) %in% c("CHR", "MAPINFO", "Chromosome_36", "Coordinate_36",
                                          "Genome_Build",
                                          "UCSC_RefGene_Name", "UCSC_RefGene_Accession",
                                          "UCSC_RefGene_Group", "UCSC_CpG_Islands_Name",
                                          "Relation_to_UCSC_CpG_Island", "Phantom",
                                          "DMR", "Enhancer",
                                          "HMM_Island", "Regulatory_Feature_Name",
                                          "Regulatory_Feature_Group", "DHS")]
 
IlluminaHumanMethylation450kannotation <- minfi:::annotationNew(Locations.hg18 = Locations.hg18,
                                                                Locations.hg19 = Locations.hg19,
                                                                everything = everything,
                                                                annotation = "IlluminaHumanMethylation450k")
save(IlluminaHumanMethylation450kannotation,
     file = "IlluminaHumanMethylation450kannotation.rda")
