/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.DescriptionGraph;

public class ShowDescriptionGraphCommand
extends AbstractCommand {
    public ShowDescriptionGraphCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "showDGraph";
    }

    public String[] getDescription() {
        return new String[]{"graphName", "prints a text representation of the description graph graphName"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showDGraph graphName");
        printWriter.println("    Prints information about the description graph with the given name.");
    }

    public void execute(String[] stringArray) {
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Graph name is missing.");
            return;
        }
        String string = stringArray[1];
        for (DescriptionGraph descriptionGraph : this.m_debugger.getTableau().getPermanentDLOntology().getAllDescriptionGraphs()) {
            if (!descriptionGraph.getName().equals(string)) continue;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            printWriter.println("===========================================");
            printWriter.println("    Contents of the graph '" + descriptionGraph.getName() + "'");
            printWriter.println("===========================================");
            printWriter.println(descriptionGraph.getTextRepresentation());
            printWriter.flush();
            this.showTextInWindow(charArrayWriter.toString(), "Contents of the graph '" + descriptionGraph.getName() + "'");
            this.selectConsoleWindow();
            return;
        }
        this.m_debugger.getOutput().println("Graph '" + string + "' not found.");
    }
}

