### R code from vignette source 'motifRG.Rnw'

###################################################
### code chunk number 1: motifRG.Rnw:73-83
###################################################
library(motifRG)
data(ctcf.seq)
data(control.seq)
### concatenate the foreground, background sequences
all.seq <- append(ctcf.seq, control.seq)
### specify which sequences are foreground, background. 
category <- c(rep(1, length(ctcf.seq)), rep(0, length(control.seq))) 
### find motifs
options(error=recover)
ctcf.motifs <- findMotif(all.seq=all.seq, category=category, max.motif=3)            


###################################################
### code chunk number 2: motifRG.Rnw:87-88
###################################################
motifLatexTable(main="CTCF motifs", ctcf.motifs)


###################################################
### code chunk number 3: motifRG.Rnw:92-95
###################################################
###Find a refined PWM model given the motif matches as seed
pwm.match <- refinePWMMotif(ctcf.motifs$motifs[[1]]@match$pattern, ctcf.seq)
library(seqLogo)


###################################################
### code chunk number 4: motifRG.Rnw:100-101
###################################################
seqLogo(pwm.match$model$prob)


###################################################
### code chunk number 5: motifRG.Rnw:107-113
###################################################
### Motifs found by findMotif tend to be relatively short, as longer and more specific
### motif models do not necessarily provide better discrimination of foreground background 
### vs background if they are already well separated.
### However, one can refine and extend a PWM model given the motif matches by findMotif as seed
### for more specific model. 
pwm.match.extend <- refinePWMMotifExtend(ctcf.motifs$motifs[[1]]@match$pattern, ctcf.seq)


###################################################
### code chunk number 6: motifRG.Rnw:118-119
###################################################
seqLogo(pwm.match.extend$model$prob)


###################################################
### code chunk number 7: motifRG.Rnw:127-128
###################################################
plotMotif(pwm.match.extend$match$pattern)


