### R code from vignette source 'CodelinkSet.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: readfile1 (eval = FALSE)
###################################################
## 
## cset <- readCodelinkSet("targets.txt")
## 


###################################################
### code chunk number 2: annotations
###################################################

library(codelink)
data(codelink.exprset)
annotation(codelink.exprset)
annotation(codelink.exprset) <- "rwgcod"
annotation(codelink.exprset)



###################################################
### code chunk number 3: preprocess
###################################################

cset <- codPreprocess(codelink.exprset)



###################################################
### code chunk number 4: plot
###################################################

codPlot(cset, what = "density")
codPlot(cset, what = "ma")
codPlot(cset, what = "image")



###################################################
### code chunk number 5: fit
###################################################

# assign example experimental conditions:
cset$Treatment = c("C", "C", "T", "T")
# create and fit model:
design <- model.matrix(~ -1 + factor(cset$Treatment))
fit <- lmFit(cset, design)



###################################################
### code chunk number 6: fit (eval = FALSE)
###################################################
## 
## writeCodelink(codelink.exprset, file = "intensities.txt")
## 


###################################################
### code chunk number 7: fit (eval = FALSE)
###################################################
## 
## foo.avg <- averageProbes(codelink.exprset)
## 


###################################################
### code chunk number 8: sessioninfo
###################################################

sessionInfo()



