### R code from vignette source 'crlmmDownstream.Rnw'

###################################################
### code chunk number 1: loadData
###################################################
library(oligoClasses)
library(VanillaICE)
library2(crlmm)
library2(SNPchip)
library2(IRanges)
data(cnSetExample, package="crlmm")


###################################################
### code chunk number 2: coerce2OligoSnpSet
###################################################
oligoSet <- as(cnSetExample, "oligoSnpSet")


###################################################
### code chunk number 3: hmm
###################################################
res <- hmm(oligoSet, p.hom=0, TAUP=1e8)


###################################################
### code chunk number 4: xyplot
###################################################
rd <- res[!state(res)%in%c(3,4), ]
fig <- SNPchip:::xyplotLrrBaf(rd[1:2, ], oligoSet,
			      frame=200e3,
			      panel=SNPchip:::xypanelBaf,
			      scales=list(x="free"),
			      par.strip.text=list(cex=0.6),
			      pch=".")


###################################################
### code chunk number 5: latticeFig
###################################################
print(fig)


