### R code from vignette source 'QUALIFIER.Rnw'

###################################################
### code chunk number 1: loadPackage-QUALIFIER
###################################################
library(QUALIFIER)


###################################################
### code chunk number 2: loadPackage-parallel (eval = FALSE)
###################################################
## library(Rmpi)
## library(snowfall)
## library(ncdfFlow)


###################################################
### code chunk number 3: parseWorkspace (eval = FALSE)
###################################################
## ws<-openWorkspace("~/QA_MFI_RBC_bounary_eventsV3.xml")
## G<-parseWorkspace(ws,execute=TRUE,isNcdf=TRUE,nslaves=6)
## saveNcdf("G","gatingHierarchy")
## save(G,file="gatingHierarchy/GS.Rda")


###################################################
### code chunk number 4: saveDB (eval = FALSE)
###################################################
## anno<-read.csv("~/FCS_File_mapping.csv")###read annotation data
## db<-new.env()
## saveToDB(db,G,anno)


###################################################
### code chunk number 5: getQAStats (eval = FALSE)
###################################################
## library(parallel)
## getQAStats(db)
## ls(db)
## db$statsOfGS[1:5,]


###################################################
### code chunk number 6: save-all (eval = FALSE)
###################################################
## save(db,file="ITNQASTUDY.rda")#save stats


###################################################
### code chunk number 7: loadData
###################################################
data("ITNQASTUDY")


###################################################
### code chunk number 8: makeQaTask
###################################################


checkListFile<-file.path(system.file("data",package="QUALIFIER"),"qaCheckList.csv.gz")
qaTask.list<-makeQaTask(db,checkListFile)
qaTask.list[1:2]


###################################################
### code chunk number 9: qaTask-RBCLysis
###################################################
qaTask.list[["RBCLysis"]]


###################################################
### code chunk number 10: qaCheck-RBCLysis
###################################################
qaCheck(qaTask.list[["RBCLysis"]],outlierfunc=outlier.cutoff,lBound=0.8)


###################################################
### code chunk number 11: plot-RBCLysis
###################################################
plot(qaTask.list[["RBCLysis"]])


###################################################
### code chunk number 12: plot-RBCLysis-subset
###################################################
plot(qaTask.list[["RBCLysis"]],subset=Tube=='CD8/CD25/CD4/CD3/CD62L')


###################################################
### code chunk number 13: plot-RBCLysis-subset2 (eval = FALSE)
###################################################
## plot(qaTask.list[["RBCLysis"]],subset=name=='06087181_F01_I010.fcs',scatterPlot=TRUE)


###################################################
### code chunk number 14: qaTask-MNC
###################################################
qaTask.list[["MNC"]]


###################################################
### code chunk number 15: qaCheck-MNC
###################################################
qaCheck(qaTask.list[["MNC"]],z.cutoff=1.5)


###################################################
### code chunk number 16: plot-MNC
###################################################
plot(qaTask.list[["MNC"]])


###################################################
### code chunk number 17: plot-MNC-scatter (eval = FALSE)
###################################################
## 
## plot(qaTask.list[["MNC"]]
## 		,scatterPlot=TRUE
## 		,subset=coresampleid==11730)


###################################################
### code chunk number 18: qaTask-BoundaryEvents
###################################################
qaTask.list[["BoundaryEvents"]]


###################################################
### code chunk number 19: qaCheck-BoundaryEvents
###################################################
qaCheck(qaTask.list[["BoundaryEvents"]]
		,sum(proportion) ~ RecdDt | name
		,outlierfunc=outlier.cutoff
		,uBound=0.0003
		)


###################################################
### code chunk number 20: plot-BoundaryEvents
###################################################
plot(qaTask.list[["BoundaryEvents"]],proportion ~ RecdDt | channel)


###################################################
### code chunk number 21: qaCheck-MFIOverTime
###################################################
qaCheck(qaTask.list[["MFIOverTime"]]
		,rFunc=rlm
		,z.cutoff=3
		)

plot(qaTask.list[["MFIOverTime"]]
		,y=MFI~RecdDt|stain
		,subset=channel%in%c('FITC-A')
		,rFunc=rlm
		,par=list(scales=list(y=c(relation="free")))
	)


###################################################
### code chunk number 22: plot-spike
###################################################
qaCheck(qaTask.list[["spike"]]
			,outlierfunc=outlier.t
			,alpha=0.00001)

plot(qaTask.list[["spike"]],y=spike~RecdDt|channel
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'&channel%in%c('FITC-A')
	)



###################################################
### code chunk number 23: tubesEvents
###################################################
tubesEvents<-read.csv(file.path(system.file("data",package="QUALIFIER"),"tubesevents.csv.gz"),row.names=1)
tubesEvents<-QUALIFIER:::.TubeNameMapping(db,tubesEvents)


###################################################
### code chunk number 24: plot-NumberOfEvents
###################################################
qaCheck(qaTask.list[["NumberOfEvents"]]
		,formula=count ~ RecdDt | Tube
		,outlierfunc=outlier.cutoff
		,lBound=0.8*tubesEvents
	)
plot(qaTask.list[["NumberOfEvents"]]
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'
	)


###################################################
### code chunk number 25: tubesEvents
###################################################
tubesEvents


###################################################
### code chunk number 26: plot-RedundantStain
###################################################
qaCheck(qaTask.list[["RedundantStain"]],z.cutoff=1)
plot(qaTask.list[["RedundantStain"]]
		,y=proportion~coresampleid|channel:stain
		,subset=stain%in%c('CD8')
	)


###################################################
### code chunk number 27: qa.report (eval = FALSE)
###################################################
## qaReport(qaTask.list,outDir="~/output",plotAll=FALSE)


