### R code from vignette source 'PING.Rnw'

###################################################
### code chunk number 1: Loading PING
###################################################
library(PING)


###################################################
### code chunk number 2: Reading the data
###################################################

path<- system.file("extdata",package="PING")
#Read the experiment : 
dataIP<-read.table(file.path(path,"GSM351492_R4_chr1.bed"),header=TRUE)
dataIP<-as(dataIP,"RangedData")
dataIP<-as(dataIP,"GenomeData")



###################################################
### code chunk number 3: Cluster initialization (eval = FALSE)
###################################################
## library(snowfall)
## sfInit(parallel=TRUE,cpus=2)
## sfLibrary(PING)


###################################################
### code chunk number 4: Genome segmentation
###################################################
seg<-segmentReads(dataIP,  minReads=NULL, maxLregion=1200,minLregion=80, jitter=T)


###################################################
### code chunk number 5: PING analysis
###################################################
ping<-PING(seg)


###################################################
### code chunk number 6: Post-process PING result
###################################################
PS=postPING(ping, seg)


###################################################
### code chunk number 7: stop cluster (eval = FALSE)
###################################################
## sfStop()


