### R code from vignette source 'MinimumDistance.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(prompt="R> ", continue=" ", device=pdf, width=65)


###################################################
### code chunk number 2: enableLD (eval = FALSE)
###################################################
## library(snow)
## library(doSNOW)
## library(oligoClasses)
## cl <- makeCluster(22, type="SOCK")
## registerDoSNOW(cl)
## parStatus()


###################################################
### code chunk number 3: registerBackend
###################################################
library(oligoClasses)
library(MinimumDistance)
foreach::registerDoSEQ()


###################################################
### code chunk number 4: filenames
###################################################
path <- system.file("extdata", package="MinimumDistance")
fnames <- list.files(path, pattern=".txt")
fnames


###################################################
### code chunk number 5: pedigreeInfo
###################################################
pedigreeInfo <- data.frame(F="F.txt", M="M.txt", O="O.txt")


###################################################
### code chunk number 6: pedigreeConstructor
###################################################
ped <- Pedigree(pedigreeInfo)
ped


###################################################
### code chunk number 7: callDenovoSegments
###################################################
map.segs <- callDenovoSegments(path=path, pedigreeData=ped,
			       cdfname="human610quadv1b",
			       chromosome=1, segmentParents=FALSE)
head(map.segs)


###################################################
### code chunk number 8: constructSampleSheet
###################################################
library(human610quadv1bCrlmm)
path <- system.file("extdata", package="MinimumDistance")
load(file.path(path, "pedigreeInfo.rda"))
load(file.path(path, "sample.sheet.rda"))
load(file.path(path, "logRratio.rda"))
load(file.path(path, "baf.rda"))
nms <- paste("NA",substr(sample.sheet$Sample.Name, 6, 10),sep="")
trioSetList <- TrioSetList(lrr=logRratio, ## must provide row.names
			   baf=baf,
			   pedigree=Pedigree(pedigreeInfo),
			   sample.sheet=sample.sheet,
			   row.names=nms,
			   cdfname="human610quadv1bCrlmm")
show(trioSetList)


###################################################
### code chunk number 9: loadTrioSetListExample
###################################################
data(trioSetListExample)


###################################################
### code chunk number 10: computeMinimumDistance
###################################################
md <- calculateMindist(lrr(trioSetList))


###################################################
### code chunk number 11: segmentMinimumDistance
###################################################
md.segs <- segment2(object=trioSetList, md=md)


###################################################
### code chunk number 12: showMd.Segs
###################################################
head(md.segs)


###################################################
### code chunk number 13: segmentLRR
###################################################
lrr.segs <- segment2(trioSetList, segmentParents=TRUE)


###################################################
### code chunk number 14: narrow
###################################################
mads.md <- mad2(md, byrow=FALSE)
md.segs2 <- narrow(md.segs, lrr.segs, thr=0.75, mad.minimumdistance=mads.md)


###################################################
### code chunk number 15: computeBayesFactor
###################################################
map.segs <- computeBayesFactor(object=trioSetList, ranges=md.segs2)
show(map.segs)


###################################################
### code chunk number 16: computeBayesFactorOneRange
###################################################
computeBayesFactor(trioSetList, md.segs2[1, ])


###################################################
### code chunk number 17: triofig
###################################################
trioSet <- stack(trioSetList)
rd.denovoDel <- map.segs[state(map.segs) == 332 & coverage2(map.segs) > 5, ]
mindist(trioSet) <- do.call("rbind", md)
frame <- 100e3
figlist <- MinimumDistance:::xyplotTrioLrrBaf(rd=rd.denovoDel,
					   object=trioSet,
					   frame=frame,
					   ylab="log R ratio and BAFs",
					   xlab="physical position",
					   panel=MinimumDistance:::xypanelTrioBaf,
					   scales=list(x="free", y=list(alternating=1)),
					   lrr.segments=lrr.segs,
					   md.segments=md.segs,
					   layout=c(1, 4), ylim=c(-3, 1.5))


###################################################
### code chunk number 18: displayFigure
###################################################
print(figlist[[1]])


###################################################
### code chunk number 19: sessionInfo
###################################################
toLatex(sessionInfo())


