### R code from vignette source 'GOSemSim.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
library(GOSemSim)
library(org.Hs.eg.db)
library(GO.db)


###################################################
### code chunk number 2: GOSemSim.Rnw:85-87
###################################################
library(GOSemSim)
help(GOSemSim)


###################################################
### code chunk number 3: old function call
###################################################
goSim("GO:0004022", "GO:0005515", ont="MF", measure="Wang")
go1 = c("GO:0004022","GO:0004024","GO:0004174")
go2 = c("GO:0009055","GO:0005515")
mgoSim(go1, go2, ont="MF", measure="Wang", combine="rcmax.avg")

geneSim("241", "251", ont="MF", organism="human", measure="Wang", combine="rcmax.avg")
mgeneSim(genes=c("835", "5261","241", "994"), ont="MF", organism="human", measure="Wang")

gs1 <- c("835", "5261","241", "994", "514", "533")
gs2 <- c("578","582", "400", "409", "411")
clusterSim(gs1, gs2, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")

x <- org.Hs.egGO
hsEG <- mappedkeys(x)
set.seed <- 123
clusters <- list(a=sample(hsEG, 20), b=sample(hsEG, 20), c=sample(hsEG, 20))
mclusterSim(clusters, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")


###################################################
### code chunk number 4: Params
###################################################
params <- new("Params", ontology="MF", organism="human", method="Wang")


###################################################
### code chunk number 5: GOSet
###################################################
go1 <- c("GO:0004022", "GO:0004024", "GO:0004023")
go2 <- c("GO:0009055", "GO:0020037")
gos <- new("GOSet", GOSet1=go1, GOSet2=go2)


###################################################
### code chunk number 6: GeneSet
###################################################
gs <- new("GeneSet", GeneSet1=gs1, GeneSet2=gs2)


###################################################
### code chunk number 7: GeneClusterSet
###################################################
geneClusters <- new("GeneClusterSet", GeneClusters=clusters)


###################################################
### code chunk number 8: sim
###################################################
sim(gos,params)
setCombineMethod(params)<-"rcmax.avg"
sim(gos,params)
sim(gs, params)
sim(geneClusters, params)


###################################################
### code chunk number 9: GOSemSim.Rnw:363-364
###################################################
sessionInfo()


